package csbase.client.applications.algorithmsmanager.versiontree.actions;

import java.awt.event.ActionEvent;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.FileInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

/**
 * Ao para remover arquivo de release notes.
 */
public class RemoveReleaseNotesFile extends AbstractVersionTreeNodeAction {

  /**
   * Verso que detm o arquivo.
   */
  private final AlgorithmVersionInfo version;

  /**
   * Arquivos a serem removidos.
   */
  private final FileInfo[] files;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param version Verso que detm os arquivos.
   * @param files Arquivos a serem removidos.
   */
  public RemoveReleaseNotesFile(VersionTree tree, AlgorithmVersionInfo version,
    FileInfo[] files) {
    super(tree, LNG.get("algomanager.menu.release.notes.remove"));

    this.version = version;
    this.files = files;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent e) {
    removeFile();
  }

  /**
   * Exibe um dilogo para confirmao de remoo de um arquivo de release note.
   */
  private void removeFile() {
    new RemoveFileDialog().show();
  }

  /**
   * Classe que representa um dilogo de remoo de arquivo de release notes.
   */
  private class RemoveFileDialog {
    /**
     * Exibe o dilogo.
     */
    public void show() {
      String removeTitle = LNG.get("algomanager.title.remove_release_notes");
      Object[] options = { LNG.get("algomanager.button.remove"), LNG.get(
        "algomanager.button.cancel") };
      int opt = StandardDialogs.showOptionDialog(getWindow(), removeTitle, LNG
        .get("algomanager.msg.confirm.release_notes.remove"), options);
      if (opt != 0) {
        return;
      }
      boolean success = AlgorithmManagementProxy.removeReleaseNotesFiles(
        version, files, getWindow());
      if (!success) {
        StandardErrorDialogs.showErrorDialog(getWindow(), LNG.get(
          "algomanager.title.error") + " - " + removeTitle, LNG.get(
            "algomanager.error.release_notes.remove"));
      }
    }
  }

}
