package csbase.client.applications.fileexchanger.panels.tablepanel;

import java.awt.BorderLayout;
import java.util.Vector;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

import tecgraf.javautils.gui.BorderUtil;
import tecgraf.javautils.gui.table.SortableTable;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.applications.fileexchanger.panels.core.FileExchangerPanel;

/**
 * Painel de operaes
 * 
 * @author Tecgraf/PUC-Rio
 */
public class TableListPanel extends FileExchangerPanel {

  /**
   * A tabela
   */
  final private SortableTable table = new SortableTable();

  /**
   * Retorna os ndices dos objetos selecionados.
   * 
   * @return os indices
   */
  final public int[] getSelectedIndexes() {
    return table.getSelectedRows();
  }

  /**
   * Inicializao da tabela (relativo ao modelo).
   */
  final private void initTableAttributes() {
    table.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);

    final FileExchanger fileExchanger = getFileExchanger();
    final TableListModel model = new TableListModel(fileExchanger);
    table.setModel(model);

    final TableListRenderer renderer = new TableListRenderer();
    table.setDefaultRenderer(Object.class, renderer);
    table.setDefaultRenderer(Double.class, renderer);
    table.setDefaultRenderer(Long.class, renderer);
    table.setDefaultRenderer(Integer.class, renderer);

    final JTableHeader header = table.getTableHeader();
    header.setReorderingAllowed(false);

    table.getSelectionModel().addListSelectionListener(
      new ListSelectionListener() {
        @Override
        public void valueChanged(ListSelectionEvent lse) {
          fileExchanger.selectionChanged();
        }
      });
  }

  /**
   * Inicializao da tabela com sua montagem em grupos, ajuste de adapters e
   * tamanhos de colunas.
   */
  final private void initTableWidthColumns() {
    final TableColumnModel columnModel = table.getColumnModel();
    final int W = 30;
    final int n = getFileExchanger().getNumShownColumns();
    final int[] widths =
      new int[] { W, W * 2, (int) (W * 1.5), (int) (W * 2.5), W * 8, W * 8,
          W * 3, W * 3, W * 3, W * 3, W * 3, W, W };
    if (n > widths.length) {
      throw new RuntimeException("Internal error on alocation size");
    }

    for (int i = 0; i < n; i++) {
      final TableColumn col = columnModel.getColumn(i);
      col.setPreferredWidth(widths[i]);
    }
  }

  /**
   * Atualizao da tabela.
   * 
   * @param structureChanged Indicativo de mudana da estrutura da tabela.
   */
  public void updateTable(boolean structureChanged) {
    final int[] sels = table.getSelectedRows();
    final TableListModel model = (TableListModel) table.getModel();
    if (structureChanged) {

      // Obtm as larguras atuais das colunas para redesenh-las com a mesma
      // largura atual.
      Vector<Integer> widthColList = new Vector<Integer>();
      TableColumnModel columnModel = table.getColumnModel();

      // Salva a largura das colunas exibidas antes da mudana da estrutura
      // da tabela.
      int columnCount = table.getColumnCount();
      for (int i = 0; i < columnCount; i++) {
        final TableColumn col = columnModel.getColumn(i);
        widthColList.add(col.getWidth());
      }

      // Atualiza a estrutura da tabela.
      model.fireTableStructureChanged();

      // Obtm o novo modelo e o nmero de colunas da tabela.
      columnModel = table.getColumnModel();
      columnCount = table.getColumnCount();

      // Nmero de colunas a serem atualizadas. Se aumentou o nmero de colunas
      // depois da mudana de estrutura da tabela, as colunas antes da mudana 
      //  que sero atualizadas. Se o nmero de colunas diminuiu, somente as
      // colunas atuais  que sero atualizadas.
      int updatedColumnCount = Math.min(widthColList.size(), columnCount);

      // Define as larguras das colunas com os valores salvos antes da mudana
      // da estrutura da tabela.
      for (int i = 0; i < updatedColumnCount; i++) {
        final TableColumn col = columnModel.getColumn(i);
        col.setPreferredWidth(widthColList.get(i));
      }

    }
    else {
      model.fireTableDataChanged();
    }
    for (int sel : sels) {
      final int nrows = table.getRowCount();
      if (sel < nrows) {
        table.addRowSelectionInterval(sel, sel);
      }
    }
  }

  /**
   * Construtor
   * 
   * @param fileExchanger a aplicao
   */
  public TableListPanel(final FileExchanger fileExchanger) {
    super(fileExchanger);
    table.setNoSortStateEnabled(true);
    initTableAttributes();
    initTableWidthColumns();

    setLayout(new BorderLayout());
    final JScrollPane scrollPane = new JScrollPane(table);
    add(scrollPane, BorderLayout.CENTER);
    table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    BorderUtil.setLowBorder(scrollPane);
  }

}
