package csbase.client.applications.flowapplication.filters;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.PickElementMessage;

/**
 * Filtro de atualizao da status bar.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class UpdateStatusBarFilter extends WorkspaceFilter {
  /**
   * Aplicao.
   */
  private FlowApplication application;

  /**
   * Elemento corrente
   */
  private GraphElement currentElement;

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public UpdateStatusBarFilter(final FlowApplication application) {
    super(application.getWorkspace());
    setApplication(application);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void callbackMove(final Point2D pt, final MouseEvent ev) {
    if (this.currentElement != null) {
      this.application.clearStatusBarMessage();
    }
    final PickElementMessage message = new PickElementMessage(pt);
    message.sendVO(this);
    this.currentElement = message.getElement();
    if (this.currentElement != null) {
      final String hint = this.currentElement.getHint(pt);
      if (hint != null) {
        this.application.setStatusBarMessage(hint);
      }
    }
    super.callbackMove(pt, ev);
  }

  /**
   * Ajuste da aplicao.
   * 
   * @param application aplicao.
   */
  private void setApplication(final FlowApplication application) {
    if (application == null) {
      throw new IllegalArgumentException("O parmetro application est nulo.");
    }
    this.application = application;
  }
}
