package csbase.client.applications.jobmonitor.columns;

import csbase.client.applications.jobmonitor.rowmodel.JobInfoRow;
import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;

/**
 * Coluna que exibe valores do tipo Double.
 * 
 * @author Tecgraf
 */
public class DoubleJobInfoColumn extends AbstractConfigurableColumn<JobInfoRow> {

  /**
   * Construtor padro.
   * 
   * @param id - identificador da coluna.
   */
  public DoubleJobInfoColumn(String id) {
    super(id, true, null, null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass() {
    return Double.class;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getColumnName() {
    return getId();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(JobInfoRow obj) {
    String value = obj.get(getId());
    return (value != null) ? Double.parseDouble(value) : null;
  }
}
