/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.actions.AbstractCommandsAction;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.ProjectTreeModel;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandInfo;
import csbase.logic.CommonClientProject;
import java.awt.event.ActionEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import tecgraf.javautils.core.io.FileUtils;

public class ShowCommandDirAction
extends AbstractCommandsAction {
    public ShowCommandDirAction(CommandsMonitor application) {
        super(application, false, ApplicationImages.ICON_TREE_16);
    }

    @Override
    protected boolean accept(CommandInfo command) {
        return true;
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        this.showCommandDirInProjectTree();
    }

    private void showCommandDirInProjectTree() {
        final CommandsMonitor application = (CommandsMonitor)this.getApplication();
        final CommandInfo command = this.getSelectedCommand();
        if (command != null) {
            String cmdId = command.getId();
            RemoteTask<Boolean> showCommandDirTask = new RemoteTask<Boolean>(){

                protected void performTask() throws Exception {
                    DesktopFrame desktopFrame = application.getDesktopFrame();
                    ProjectTree projectTree = desktopFrame.getTree();
                    CommonClientProject project = projectTree.getProject();
                    JTree jTree = projectTree.getTree();
                    String[] persistencyPath = command.getPersistencyPath();
                    if (persistencyPath == null || persistencyPath.length == 0) {
                        this.setResult(false);
                        return;
                    }
                    ClientProjectFile persistencyDir = project.getFile(persistencyPath);
                    ProjectTreeModel model = (ProjectTreeModel)jTree.getModel();
                    TreePath cmdNode = model.getTreePath(persistencyDir);
                    if (cmdNode == null) {
                        this.setResult(false);
                        return;
                    }
                    jTree.expandPath(cmdNode);
                    jTree.setSelectionPath(cmdNode);
                    jTree.scrollPathToVisible(cmdNode);
                    this.setResult(true);
                }
            };
            String title = this.getString("ShowCommandDirAction.task.show.commands.dir.title", new Object[0]);
            String message = this.getString("ShowCommandDirAction.task.show.commands.dir.message", new Object[0]);
            if (!showCommandDirTask.execute(application.getApplicationFrame(), title, message)) {
                application.showException(this.getString("ShowCommandDirAction.task.show.commands.dir.error", FileUtils.fixDirectoryName((String)cmdId)), showCommandDirTask.getError());
            } else {
                Boolean result = (Boolean)showCommandDirTask.getResult();
                if (result == null || !result.booleanValue()) {
                    application.showError(this.getString("ShowCommandDirAction.task.show.commands.dir.error.not.found", new Object[0]));
                }
            }
        }
    }
}

