/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui;

import csbase.client.util.gui.AlgorithmFilterParamPanelListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

public class AlgorithmFilterParamPanel
extends JPanel {
    private static final Border ERROR_BORDER = BorderFactory.createLineBorder(Color.RED, 2);
    private Border defaultTextFieldBorder;
    private JCheckBox ignoreCaseBox;
    private JTextField textField;
    private JCheckBox useRegexBox;
    private JCheckBox showSimpleBox;
    private JCheckBox showFlowBox;
    private List<AlgorithmFilterParamPanelListener> listeners = new ArrayList<AlgorithmFilterParamPanelListener>();

    public AlgorithmFilterParamPanel() {
        this.textField = new JTextField();
        this.ignoreCaseBox = new JCheckBox(this.getString("ignoreCaseCheckBox.label", new Object[0]));
        this.useRegexBox = new JCheckBox(this.getString("regexCheckBox.label", new Object[0]));
        this.showSimpleBox = new JCheckBox(this.getString("simpleCheckBox.label", new Object[0]));
        this.showFlowBox = new JCheckBox(this.getString("fluxCheckBox.label", new Object[0]));
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                AlgorithmFilterParamPanel.this.updateState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                AlgorithmFilterParamPanel.this.updateState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AlgorithmFilterParamPanel.this.updateState();
            }
        });
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                String text = AlgorithmFilterParamPanel.this.textField.getText();
                if (text.length() != 0) {
                    AlgorithmFilterParamPanel.this.textField.select(0, text.length());
                }
            }
        });
        this.defaultTextFieldBorder = this.textField.getBorder();
        this.ignoreCaseBox.setSelected(true);
        this.ignoreCaseBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmFilterParamPanel.this.updateState();
            }
        });
        this.useRegexBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmFilterParamPanel.this.updateState();
                if (AlgorithmFilterParamPanel.this.useRegexBox.isSelected()) {
                    AlgorithmFilterParamPanel.this.ignoreCaseBox.setEnabled(false);
                } else {
                    AlgorithmFilterParamPanel.this.ignoreCaseBox.setEnabled(true);
                }
            }
        });
        this.showSimpleBox.setSelected(true);
        this.showSimpleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmFilterParamPanel.this.updateState();
            }
        });
        this.showFlowBox.setSelected(true);
        this.showFlowBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmFilterParamPanel.this.updateState();
            }
        });
        JPanel flowOrSimplePanel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC(0, 0).northwest().none().insets(0, 0, 0, 2);
        flowOrSimplePanel.add((Component)this.showSimpleBox, gbc);
        flowOrSimplePanel.add((Component)this.showFlowBox, gbc.gridx(1).insets(0, 0, 0, 0));
        JPanel searchPanel = new JPanel(new GridBagLayout());
        gbc = new GBC(1, 1).northwest().none().insets(2, 2, 2, 2).weights(0.0, 0.0);
        searchPanel.add((Component)this.ignoreCaseBox, gbc);
        searchPanel.add((Component)this.useRegexBox, gbc.gridy(2));
        searchPanel.add((Component)this.textField, gbc.gridy(3).weightx(1.0).horizontal());
        searchPanel.add((Component)flowOrSimplePanel, gbc.gridy(4).weightx(0.0).none());
        searchPanel.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.add((Component)searchPanel, "North");
    }

    public void addListener(AlgorithmFilterParamPanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AlgorithmFilterParamPanelListener listener) {
        this.listeners.remove(listener);
    }

    public void updateState() {
        if (this.useRegexBox.isSelected() && this.getRegexPattern() == null) {
            this.textField.setBorder(ERROR_BORDER);
            return;
        }
        this.textField.setBorder(this.defaultTextFieldBorder);
        for (AlgorithmFilterParamPanelListener listener : this.listeners) {
            listener.panelChanged(this.ignoreCaseBox.isSelected(), this.useRegexBox.isSelected(), this.showSimpleBox.isSelected(), this.showFlowBox.isSelected(), this.textField.getText());
        }
    }

    public Pattern getRegexPattern() {
        String text = this.textField.getText();
        try {
            return Pattern.compile(text);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    private String getString(String tag, Object ... args) {
        String prefix = this.getClass().getSimpleName();
        String fmt = LNG.get((String)(prefix + "." + tag));
        String text = String.format(fmt, args);
        return text;
    }

    public JTextField getTextField() {
        return this.textField;
    }
}

