/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log;

import csbase.client.util.event.EventListener;
import csbase.client.util.event.EventManager;
import csbase.client.util.event.IEvent;
import csbase.client.util.gui.log.Reloadable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class LogPanelReloader {
    public static final long DEFAULT_TIME_SECS = 10L;
    public static final long MIN_TIME_SECS = 5L;
    private final Reloadable reloadable;
    private final AtomicBoolean running;
    private final AtomicLong period;
    private final EventManager eventManager;
    private final ReloadTask task;
    private volatile Thread thread;

    public LogPanelReloader(Reloadable reloadable) {
        this.reloadable = reloadable;
        this.period = new AtomicLong();
        this.running = new AtomicBoolean(false);
        this.eventManager = new EventManager();
        this.task = new ReloadTask();
        this.setTime(10L);
    }

    public final void start() {
        if (this.running.compareAndSet(false, true) || null == this.thread || !this.thread.isAlive()) {
            this.thread = new Thread(this.task);
            this.thread.setDaemon(true);
            this.thread.start();
            this.eventManager.fireEvent(new StatusChangedEvent(true));
        }
        this.eventManager.fireEvent(new StartEvent());
    }

    public final void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.thread = null;
            this.eventManager.fireEvent(new StatusChangedEvent(false));
        }
        this.eventManager.fireEvent(new StopEvent());
    }

    public final boolean isRunning() {
        return this.running.get();
    }

    public void setTime(long period) {
        this.period.set(Math.max(5L, period));
    }

    public void addStatusChangedEventListener(EventListener<StatusChangedEvent> listener) {
        this.eventManager.addEventListener(listener, StatusChangedEvent.class);
    }

    public void addStopEventListener(EventListener<StopEvent> listener) {
        this.eventManager.addEventListener(listener, StopEvent.class);
    }

    public void addStartEventListener(EventListener<StartEvent> listener) {
        this.eventManager.addEventListener(listener, StartEvent.class);
    }

    class ReloadTask
    implements Runnable {
        ReloadTask() {
        }

        @Override
        public void run() {
            Thread thisThread = Thread.currentThread();
            while (LogPanelReloader.this.thread == thisThread) {
                LogPanelReloader.this.reloadable.reload();
                try {
                    TimeUnit.SECONDS.sleep(LogPanelReloader.this.period.get());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class StartEvent
    implements IEvent {
    }

    public static class StopEvent
    implements IEvent {
    }

    public static class StatusChangedEvent
    implements IEvent {
        private final boolean running;

        StatusChangedEvent(boolean running) {
            this.running = running;
        }

        public boolean isRunning() {
            return this.running;
        }
    }
}

