package csbase.logic;

/**
 * Super-classe das classes de permisso que possuem, alm do nome e da
 * descrio, um par de usurio e senha.
 * A senha s  mantida nas instncias desta classe no servidor no atributo
 * localPassword. 
 * O atributo password serve para passar a senha do cliente
 * para o servidor na incluso ou na alterao. Depois que a senha  persistida
 * ela  mantida no atributo transient localPassword que fica apenas
 * no servidor.
 */
public abstract class UserPasswordPermission extends Permission {
  protected String user;
  /**
   * Senha que vem do cliente, mas  apagada depois que  persistida pelo
   * servidor.
   */
  protected String password;
  /**Senha usada apenas pelo servidor*/
  protected transient String localPassword;

  /**
   * Construtor.
   */
  public UserPasswordPermission() {
    super();
  }

  /**
   * Construtor. Define o nome, o usurio e a senha da permisso sendo criada.
   *
   * @param name Nome da permisso.
   * @param description Descrio da permisso.
   * @param user Usurio associado.
   * @param password Senha associado.
   */
  public UserPasswordPermission(
    String name, String description, String user, String password) {
    super(name, description);
    this.user = (user!=null ? user : "");
    this.password = (password!=null ? password : "");
  }

  public String getUser() {
    return user;
  }

  public void setUser(String user) {
    this.user = user;
  }

  /**
   * Mtodo para obtenao da senha no servidor
   *
   * @return Senha decriptografada.
   */
  public String getLocalPassword() {
    return localPassword;
  }

  public void setLocalPassword(String localPassword) {
    this.localPassword = localPassword;
  }

  /**
   * Mtodo para obteno da senha que vem do cliente na alterao ou na 
   * incluso de UserPasswordPermission. Este atributo fica nulo depois que
   *  persistido. Para obter a senha no servidor, use o mtodo
   * getLocalPassword().
   *
   * @return a senha digita pelo cliente
   *
   */
  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public boolean equalContents(Object obj) {
    if (!super.equalContents(obj)) {
      return false;
    }
    if (!(obj instanceof UserPasswordPermission)) {
      return false;
    }
    UserPasswordPermission permission = (UserPasswordPermission)obj;
    return permission.getUser().equals(user) &&
           permission.getLocalPassword().equals(localPassword);
  }
}
