package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TableParameter;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * <p>
 * Fbrica de {@link TableColumn}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo tabela. O elemento corrente
 * do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link TableParameter}.
 * </p>
 */
public interface TableColumnFactory {

  /**
   * Obtm o nome do elemento XML que esta fbrica  capaz de analisar.
   *
   * @return .
   */
  String getElementName();

  /**
   * <p>
   * Carrega uma coluna da tabela.
   * </p>
   *
   * @param parser O analisador (No aceita {@code null}).
   * @param name O nome da tabela (No aceita {@code null}).
   * @param configurator O configurador de algoritmos (No aceita {@code null}).
   *
   * @return A coluna.
   *
   * @throws ParseException Se houver um erro no XML.
   */
  TableColumn<?> createColumn(XmlParser parser, String name,
    SimpleAlgorithmConfigurator configurator) throws ParseException;

  /**
   * Atribui o valor a uma clula na coluna.
   *
   * @param parser O analisador de XML (No aceita {@code null}).
   * @param parameterName O nome da tabela que est sendo processado (No aceita
   *        {@code null}).
   * @param column A coluna que ser alterada (No aceita {@code null}).
   * @param rowIndex O ndice da linha.
   * @param valueAttributeName O nome do atributo de XML com o valor-padro da
   *        clula (No aceita {@code null}).
   * @throws ParseException Se houver um erro no XML.
   */
  void setCellValue(XmlParser parser, String parameterName,
    TableColumn<?> column, int rowIndex, String valueAttributeName)
      throws ParseException;

}