/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.FormulaParameterValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.openbus.algorithmservice.v1_0.parameters.FormulaParameterHelper;

public final class FormulaParameter
extends SimpleParameter<String> {
    private static final String CMD_TEXT_PROPERTY = "cmd_text";
    private static final String USER_CHARACTER_PROPERTY = "user_char";
    private List<String> commandTexts;
    private List<Character> userCharacters;

    public FormulaParameter(String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern) {
        super(name, label, description, null, isOptional, isVisible, commandLinePattern);
        Class<?> thisClass = this.getClass();
        String thisClassName = thisClass.getSimpleName();
        String resName = thisClassName + ".properties";
        InputStream inStream = thisClass.getResourceAsStream(resName);
        Properties properties = new Properties();
        try {
            properties.load(inStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.commandTexts = new ArrayList<String>();
        this.userCharacters = new ArrayList<Character>();
        int i = 1;
        while (true) {
            String cmdPropName = "cmd_text." + i;
            String usrPropName = "user_char." + i;
            if (!properties.containsKey(cmdPropName)) break;
            String commandText = properties.getProperty(cmdPropName);
            String cmdRegex = "[A-Za-z0-9_]+";
            Pattern cmdPattern = Pattern.compile("[A-Za-z0-9_]+");
            Matcher cmdMatcher = cmdPattern.matcher(commandText);
            if (!cmdMatcher.matches()) {
                String err = String.format("O texto de comando %s.%d (%s) est\u00e1 no formato errado. Express\u00e3o regular: %s.\n", CMD_TEXT_PROPERTY, i, commandText, "[A-Za-z0-9_]+");
                throw new IllegalArgumentException(err);
            }
            this.commandTexts.add(commandText);
            String userCharacter = properties.getProperty(usrPropName);
            String usrRegex = "^<(.)>$";
            Pattern usrPattern = Pattern.compile("^<(.)>$");
            Matcher usrMatcher = usrPattern.matcher(userCharacter);
            if (!usrMatcher.matches()) {
                String errorMessage = String.format("O caractere de usu\u00e1rio %s.%d (%s) est\u00e1 no formato errado. Express\u00e3o regular: %s.\n", USER_CHARACTER_PROPERTY, i, userCharacter, "^<(.)>$");
                throw new IllegalArgumentException(errorMessage);
            }
            String ch = usrMatcher.group(1);
            this.userCharacters.add(Character.valueOf(ch.charAt(0)));
            ++i;
        }
    }

    public String getCommandValue() {
        String value = (String)this.getValue();
        return this.getEncodedValue(value);
    }

    public String getEncodedValue(String value) {
        if (value == null) {
            return null;
        }
        String encodedValue = value.replace("_", "__Underline__");
        for (int i = 0; i < this.userCharacters.size(); ++i) {
            String userText = Character.toString(this.userCharacters.get(i).charValue());
            String commandText = String.format("__%s__", this.commandTexts.get(i));
            encodedValue = encodedValue.replace(userText, commandText);
        }
        return encodedValue;
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    @Override
    public String getType() {
        return "FORMULA";
    }

    @Override
    public String getIDLType() {
        return FormulaParameterHelper.id();
    }

    @Override
    public void setValueAsText(String parameterValue) {
        this.setValue(parameterValue);
    }

    @Override
    protected String getCommandValue(CommandLineContext context) {
        return this.getCommandValue();
    }

    public FormulaParameterValidator createParameterValidator() {
        return new FormulaParameterValidator(this.isOptional());
    }
}

