package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;

/**
 * <p>
 * Analisador de {@link InputFileParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "arquivo de entrada"
 * simples. O elemento corrente do {@link XmlParser analisador de XML} precisa
 * ser um elemento {@link InputFileParameter}.
 * </p>
 *
 */
public class InputFileParameterParser extends
  AbstractFileParameterParser<InputFileParameter> {

  /**
   * <p>
   * O elemento {@value #INPUT_FILE_PARAMETER_ELEMENT}: descreve as propriedades
   * de um {@link InputFileParameter parmetro do tipo arquivo de entrada}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String INPUT_FILE_PARAMETER_ELEMENT =
    "arquivo_de_entrada";

  /**
   * {@inheritDoc}
   */
  @Override
  public InputFileParameter createFileParameter(XmlParser parser, String name,
    String label, String description, boolean isOptional, boolean isVisible,
    String commandLinePattern, String[] types, FileParameterMode mode)
      throws ParseException {

    final boolean sortDefined = parser.hasAttributeValue(
      FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE);
    if (sortDefined) {
      boolean mustSort = parser.extractAttributeValueAsBoolean(
        FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE,
        FILE_PARAMETER_ELEMENT_MUST_SORT_DEFAULT_VALUE);
      if (mustSort) {
        throw new ParseException(
          "Arquivo de entrada (seleo nica) no admite atributo: "
            + FILE_PARAMETER_ELEMENT_MUST_SORT_ATTRIBUTE);
      }
    }

    FileParameterPipeAcceptance usesPipe = parser
      .extractAttributeValueAsEnumeration(
        FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE,
        FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_DEFAULT_VALUE,
        new FileParameterPipeAcceptanceConverter());

    if(usesPipe != FileParameterPipeAcceptance.FALSE && types.length > 1) {
      throw new ParseException(
        "O valor {0} do atributo {1}  invlido quando se tem mais de um tipo " +
          "de arquivo definido no parmetro.",
        usesPipe, FILE_PARAMETER_ELEMENT_CAN_USE_PIPE_ATTRIBUTE);
    }

    boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean(
      FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE,
      FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_DEFAULT_VALUE);
    FileURLValue defaultValue = null;
    if (useRootDirectoryAsDefault) {
      if (mode == FileParameterMode.REGULAR_FILE) {
        throw new ParseException(
          "O atributo {0}  invlido quando o parmetro de entrada  um arquivo.",
          new Object[] {
              FILE_PARAMETER_ELEMENT_USE_ROOT_AS_DEFAULT_DIRECTORY_ATTRIBUTE });
      }
      defaultValue = new FileURLValue(".", ProjectFileType.DIRECTORY_TYPE);
    }

    boolean useFilter = parser.extractAttributeValueAsBoolean(
      FILE_PARAMETER_ELEMENT_USE_FILTER_ATTRIBUTE,
      FILE_PARAMETER_ELEMENT_USE_FILTER_DEFAULT_VALUE);

    InputFileParameter parameter = new InputFileParameter(name, label,
      description, defaultValue, isOptional, isVisible, commandLinePattern,
      types, mode, usesPipe, useFilter);
    return parameter;
  }

  @Override
  protected boolean acceptBothCategory() {
    return true;
  }
}
