/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;

public class BooleanParameterFactory
extends SimpleParameterParser<BooleanParameter> {
    public static final String BOOLEAN_PARAMETER_ELEMENT = "booleano";
    public static final String BOOLEAN_ELEMENT_FALSE_ATTRIBUTE = "falso";
    public static final String BOOLEAN_ELEMENT_TRUE_ATTRIBUTE = "verdadeiro";

    @Override
    public BooleanParameter createSimpleParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        boolean defaultValue = parser.extractAttributeValueAsBoolean("padrao", false);
        String falseCommand = parser.extractAttributeValue(BOOLEAN_ELEMENT_FALSE_ATTRIBUTE, null);
        String trueCommand = parser.extractAttributeValue(BOOLEAN_ELEMENT_TRUE_ATTRIBUTE, null);
        return new BooleanParameter(name, label, description, defaultValue, isVisible, commandLinePattern, falseCommand, trueCommand);
    }
}

