/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.conditions.AndOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.GenericCondition;
import csbase.logic.algorithms.parameters.conditions.NotOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.OrOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.LinkedList;

public class ConditionParser {
    static final String CONDITION_ELEMENT = "condicao";
    static final String AND_ELEMENT = "e";
    static final String NOT_ELEMENT = "nao";
    static final String OR_ELEMENT = "ou";
    private static final String CONDITION_ELEMENT_PARAMETER_ATTRIBUTE = "parametro";
    private static final String CONDITION_ELEMENT_VALUE_ATTRIBUTE = "valor";

    public Condition loadCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String elementName = parser.getElementName();
        if (elementName.equals(CONDITION_ELEMENT)) {
            return this.loadConditionElement(parser, configurator);
        }
        if (elementName.equals(OR_ELEMENT)) {
            return this.loadOrCondition(parser, configurator);
        }
        if (elementName.equals(AND_ELEMENT)) {
            return this.loadAndCondition(parser, configurator);
        }
        if (elementName.equals(NOT_ELEMENT)) {
            return this.loadNotCondition(parser, configurator);
        }
        return null;
    }

    private Condition loadConditionElement(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Object value;
        String expressionText = parser.getElementValue(null);
        if (expressionText != null) {
            try {
                return new GenericCondition(expressionText);
            }
            catch (FormulaCreationException e) {
                throw new ParseException(e, "Erro ao interpretar a express\u00e3o {0}.\nDetalhes:\n{1}", expressionText, e.getLocalizedMessage());
            }
        }
        String parameterName = parser.extractAttributeValue(CONDITION_ELEMENT_PARAMETER_ATTRIBUTE);
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException("O par\u00e2metro {0} que est\u00e1 referenciado no elemento {1} atributo {2} n\u00e3o est\u00e1 definido.", parameterName, CONDITION_ELEMENT, CONDITION_ELEMENT_PARAMETER_ATTRIBUTE);
        }
        if (parameter instanceof BooleanParameter) {
            value = new Boolean(parser.extractAttributeValueAsBoolean(CONDITION_ELEMENT_VALUE_ATTRIBUTE));
        } else if (parameter instanceof TextParameter) {
            value = parser.extractAttributeValue(CONDITION_ELEMENT_VALUE_ATTRIBUTE, null);
        } else if (parameter instanceof DoubleParameter) {
            value = parser.extractAttributeValueAsDouble(CONDITION_ELEMENT_VALUE_ATTRIBUTE, null);
        } else if (parameter instanceof IntegerParameter) {
            value = parser.extractAttributeValueAsInteger(CONDITION_ELEMENT_VALUE_ATTRIBUTE, null);
        } else if (parameter instanceof EnumerationParameter) {
            EnumerationParameter enumerationParameter = (EnumerationParameter)parameter;
            String itemId = parser.extractAttributeValue(CONDITION_ELEMENT_VALUE_ATTRIBUTE);
            EnumerationItem item = enumerationParameter.getItem(itemId);
            if (item == null) {
                throw new ParseException("O item {1} do par\u00e2metro {0} referenciado em uma condi\u00e7\u00e3o n\u00e3o foi definido.", parameter, itemId);
            }
            value = item;
        } else {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o pode participar de uma condi\u00e7\u00e3o.\nApenas os tipos {1}, {2}, {3}, {4} e {5} s\u00e3o permitidos.", parameter, "booleano", "texto", "real", "inteiro", "enumeracao");
        }
        parser.checkAttributes();
        parser.checkChildElements();
        return new SimpleCondition(parameter.getName(), value);
    }

    private AndOperatorCondition loadAndCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        parser.checkAttributes();
        if (!parser.goToFirstChild()) {
            throw new ParseException("A condi\u00e7\u00e3o de uma restri\u00e7\u00e3o n\u00e3o est\u00e1 definida.");
        }
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        do {
            Condition condition;
            if ((condition = this.loadCondition(parser, configurator)) == null) continue;
            conditions.add(condition);
        } while (parser.goToNextSibling());
        if (conditions.size() < 2) {
            throw new ParseException(String.format("A lista de condi\u00e7\u00f5es do operador OU tem que ter pelo menos 2 condi\u00e7\u00f5es associadas.\nN\u00famero de condi\u00e7\u00f5es associadas: %d.\n", conditions.size()));
        }
        AndOperatorCondition andOperatorCondition = new AndOperatorCondition(conditions);
        parser.goToParent();
        return andOperatorCondition;
    }

    private Condition loadNotCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        parser.checkAttributes();
        if (!parser.goToFirstChild()) {
            throw new ParseException("A condi\u00e7\u00e3o de uma restri\u00e7\u00e3o n\u00e3o est\u00e1 definida.");
        }
        Condition condition = this.loadCondition(parser, configurator);
        if (condition == null) {
            throw new ParseException("A condi\u00e7\u00e3o de uma restri\u00e7\u00e3o n\u00e3o est\u00e1 definida.");
        }
        NotOperatorCondition notOperatorCondition = new NotOperatorCondition(condition);
        parser.goToParent();
        return notOperatorCondition;
    }

    private Condition loadOrCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        parser.checkAttributes();
        if (!parser.goToFirstChild()) {
            throw new ParseException("A condi\u00e7\u00e3o de uma restri\u00e7\u00e3o n\u00e3o est\u00e1 definida.");
        }
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        do {
            Condition condition;
            if ((condition = this.loadCondition(parser, configurator)) == null) continue;
            conditions.add(condition);
        } while (parser.goToNextSibling());
        if (conditions.size() < 2) {
            throw new ParseException(String.format("A lista de condi\u00e7\u00f5es do operador OU tem que ter pelo menos 2 condi\u00e7\u00f5es associadas.\nN\u00famero de condi\u00e7\u00f5es associadas: %d.\n", conditions.size()));
        }
        OrOperatorCondition orOperatorCondition = new OrOperatorCondition(conditions);
        parser.goToParent();
        return orOperatorCondition;
    }
}

