package csbase.exception;

/**
 * Exceo para distinguir falhas na execuo de um servio por causa de
 * parmetros invlidos/inadequados passados pelo cliente. 
 * 
 * @author lbarros
 */
public class InvalidRequestException extends ServiceFailureException {

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   *
   * @param clientMessage a descrio do erro
   */  
  public InvalidRequestException(String clientMessage) {
    super(clientMessage);
  }

  /**
   * Constri uma exceo contendo a causa do erro e uma informao adicional
   * para o log do servidor.
   *
   * @param clientMessage A descrio do erro.
   * @param detailMessage A informao adicional.
   */  
  public InvalidRequestException(String clientMessage, String detailMessage) {
    super(clientMessage, detailMessage);
  }

  /**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   *
   * @param clientMessage a descrio do erro
   * @param exception a exceo original
   */
  public InvalidRequestException(String clientMessage, Throwable exception) {
    super(clientMessage, exception);
  }

  /**
   * Constri uma exceo contendo a causa do erro e uma informao adicional
   * para o log do servidor.
   *
   * @param clientMessage A descrio do erro.
   * @param detailMessage A informao adicional.
   * @param throwable A causa do erro.
   */  
  public InvalidRequestException(String clientMessage, String detailMessage,
                                 Throwable throwable) {
    super(clientMessage, detailMessage, throwable);
  }

}
