package csbase.exception;

import java.text.MessageFormat;

/**
 * Uma exceo para sinalizar erros durante operaes de um parser.
 */
public class ParseException extends CSBaseException {
/**
     * Constri uma exceo contendo a descrio do erro correspondente.
     *
     * @param message a descrio do erro
     */
  public ParseException(String message) {
    super(message);
  }

/**
     * Constri uma exceo contendo a descrio do erro correspondente.
     *
     * @param pattern um padro com a descrio do erro
     * @param arguments os argumentos que sero formatados na descrio do erro
     *
     * @see MessageFormat
     */
  public ParseException(String pattern, Object... arguments) {
    super(pattern, arguments);
  }

/**
     * Constri uma exceo contendo a descrio do erro e a causa/exceo
     * original.
     *
     * @param message a descrio do erro
     * @param exception a exceo original
     */
  public ParseException(String message, Throwable exception) {
    super(message, exception);
  }

/**
     * Constri uma exceo contendo a descrio do erro correspondente e a
     * causa/exceo original.
     *
     * @param exception a exceo original
     * @param pattern um padro com a descrio do erro
     * @param arguments os argumentos que sero formatados na descrio do erro
     *
     * @see MessageFormat
     */
  public ParseException(
    Throwable exception, String pattern, Object... arguments) {
    super(pattern, arguments, exception);
  }
}
