/**
 * $Id: ProjectFileDeletedEvent.java 146059 2013-10-22 18:32:34Z fpina $
 */

package csbase.logic;

/**
 * Representa o evento de remoo de um arquivo na rvore do projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectFileDeletedEvent extends ProjectEvent {
  /**
   * O caminho do arquivo.
   */
  private String[] path;
  /**
   * O ndice.
   */
  private int index;
  /**
   * O arquivo excludo.
   */
  private ClientProjectFile removedFile;

  /**
   * Retorna o caminho do arquivo excludo como resultado do evento ocorrido.
   * 
   * @return O caminho do arquivo excludo.
   */
  public String[] getPath() {
    return path;
  }

  /**
   * Ajuste do ndice
   * 
   * @param index o ndice
   */
  public void setRemovedFileIndex(int index) {
    this.index = index;
  }

  /**
   * Consulta ao ndice
   * 
   * @return o ndice
   */
  public int getRemovedFileIndex() {
    return index;
  }

  /**
   * Define o arquivo excludo.
   * 
   * @param file o arquivo excludo.
   */
  public void setRemovedFile(ClientProjectFile file) {
    this.removedFile = file;
  }

  /**
   * Obtm o arquivo excludo.
   * 
   * @return o arquivo excludo.
   */
  public ClientProjectFile getRemovedFile() {
    return this.removedFile;
  }

  /**
   * Cria uma instncia de <code>ProjectEvent</code> para o evento de remoo de
   * um arquivo na rvore de um projeto.
   * 
   * @param projectId o identificador do projeto de qual o arquivo foi excludo.
   * @param path O caminho do arquivo excludo.
   */
  public ProjectFileDeletedEvent(Object projectId, String[] path) {
    event = FILE_DELETED;
    this.projectId = projectId;
    this.path = path;
  }
}
