/*
 * $Id$
 */
package csbase.logic;

/**
 * Interface para os ouvintes de ServerMonitor
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
public interface ServerMonitorListener {

  /**
   * Chamado quando ServerMonitor detecta que o servidor no est alcanvel
   * 
   * @param serverURI A URI do servidor que caiu
   */
  public void notifyServerUnreachable(ServerURI serverURI);

  /**
   * Chamado quando o ServerMonitor reestabelece a conexo com o servidor
   * 
   * @param serverURI A URI do servidor reestabelecido
   */
  public void notifyServerReachable(ServerURI serverURI);

}
