/*
 * $Id: ValidationResult.java 111102 2010-10-07 21:53:04Z clinio $
 */
package csbase.logic.algorithms.validation;

/**
 * Resultado de uma validao.
 * 
 * @author Tecgraf/PUC-Rio
 */
public abstract class ValidationResult implements Validation {
  /**
   * Mensagem de erro (ou {@code null} em caso de sucesso).
   */
  private LocalizedMessage message;

  /**
   * Cria o resultado do caso de sucesso.
   */
  public ValidationResult() {
  }

  /**
   * Cria o resultado do caso de erro.
   * 
   * @param message mensagem de erro.
   */
  public ValidationResult(LocalizedMessage message) {
    setErrorMessage(message);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public LocalizedMessage getMessage() {
    return this.message;
  }

  /**
   * Atribui a mensagem de erro.
   * 
   * @param message A mensagem de erro (No aceita {@code null}).
   */
  protected void setErrorMessage(LocalizedMessage message) {
    if (message == null) {
      throw new IllegalArgumentException("O parmetro message est nulo.");
    }
    this.message = message;
  }

}
