/*
 * UserProjectsArgObserver.java
 *
 * $Author$
 * $Revision$  - $Date$
 */
package csbase.logic;

import java.io.Serializable;

/**
 * Representa um argumento para observao de todos os projetos de um usurio.
 *
 * @author Taciana
 * @version $Revision$
 */
public class UserProjectsArgObserver implements Serializable {
  /** Identificador do usurio do projeto */
  private Object userId;

  /**
   * Obtm o identificador do usurio dono do projeto.
   *
   * @return O identificador do usurio.
   */
  public Object getUserId() {
    return userId;
  }

  /**
   * Testa se um <code>UserProjectsArgObserver</code>  igual a um outro 
   * objeto. Dois objetos <code>UserProjectsArgObserver</code> so iguais 
   * de forem da mesma classe e se possuirem as mesmas informaes.
   *
   * @param obj .
   *
   * @return Verdadeiro, se os objetos forem iguais ou falso, caso contrrio.
   */
  public boolean equals(Object obj) {
    if (!(obj instanceof UserProjectsArgObserver)) {
      return false;
    }
    UserProjectsArgObserver info = (UserProjectsArgObserver)obj;
    return ((this.userId == info.userId) || this.userId.equals(info.userId));
  }

  /**
   * Cdigo hash do objeto.
   *
   * @return inteiro representando o cdigo hash.
   */
  public int hashCode() {
     // XXX atributo pode nulo? 
     return (userId == null) ? "userIdNull".hashCode() : userId.hashCode();
  }

  /**
   * Constri um <code>UserProjectsArgObserver</code> com as informaes 
   * sobre um projeto e seu dono.
   *
   * @param userId Identificador do usurio adminitrador do projeto.
   */
  public UserProjectsArgObserver(Object userId) {
    this.userId = userId;
  }
}
