package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * <p>
 * Gatilho Ocultar Parmetro: Oculta o {@link SimpleParameter parmetro} quando
 * a {@link Condition condio} associada for aceita.
 * </p>
 * 
 * @author lmoreira
 */
public final class HideParameterTrigger extends Trigger<SimpleParameter<?>> {
  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   */
  public HideParameterTrigger(SimpleParameter<?> parameter,
    Condition condition) {
    super(parameter, condition);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setVisible(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setVisible(true);
  }
}
