/**
 * $Id$
 */
package csbase.remote;

import csbase.exception.CSBaseException;
import csbase.logic.Session;

/**
 * Representa um autenticador de usurios no servidor.
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface Authenticator {
  /**
   * Autentica um usurio no servidor.
   * 
   * @param server O servidor.
   * 
   * @return A sesso do usurio ou {@code null}, caso no seja possvel
   *         autenticar o usurio.
   * 
   * @throws CSBaseException Caso ocorra algum erro no procedimento.
   */
  Session authenticate(ServerEntryPoint server) throws CSBaseException;
}
