/*
 * $Id$
 */
package csbase.remote;

import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * Interface remota para acesso  funcionalidade comum a todos os servios do
 * Server.
 */
public interface ServiceInterface extends Remote {
  /**
   * Informa o nome do servio.
   * 
   * @return o nome do servio.
   * @throws RemoteException se houver erro de chamada remota.
   */
  public String getName() throws RemoteException;

  /**
   * Verifica se o servio est ativo
   * 
   * @return true se o servio est ativo e apto a atender solicitaes
   * @throws RemoteException se houver erro de chamada remota.
   */
  public boolean isActive() throws RemoteException;
}
