/*
 * $Id$
 */

package csbase.logic;

/**
 * 
 * Indica o que levou o comando a terminar.<br>
 * Pode ser vista como uma classificao do comando dentro do estado
 * {@link CommandStatus#FINISHED}. Caso ele no esteja neste estado, seu
 * {@link CommandFinalizationType} deve ser
 * {@link CommandFinalizationType#NOT_FINISHED}.
 * 
 * @author Tecgraf / PUC-Rio
 */
public enum CommandFinalizationType {
  /**
   * O comando no est no estado {@link CommandStatus#FINISHED}
   */
  NOT_FINISHED("O comando ainda est em execuo."),
  /**
   * No se sabe em que condies o comando terminou, pois o comando  antigo.<br>
   * Ser utilizado na visualizao de dados de comandos persistidos antes da
   * criao desta classificao.
   */
  UNKNOWN("Comando terminado em estado indeterminado."),
  /**
   * No se sabe em que condies o comando terminou, pois o comando no
   * informa.<br>
   * Ser utilizado na visualizao de dados de comandos que no informam o
   * cdigo de sada durante a execuo.
   */
  END("Comando terminado."),
  /**
   * O comando terminou com sucesso (retornou cdigo de sada de execuo igual
   * a zero).
   */
  SUCCESS("Comando terminado com sucesso."),
  /**
   * O comando terminou com erro (retornou cdigo de sada de execuo diferente
   * de zero).
   */
  EXECUTION_ERROR("Comando terminado com erro."),
  /**
   * Houve uma falha na inicializao do comando.
   */
  FAILED("Houve falha na inicializao do comando."),
  /**
   * O comando foi cancelado.
   */
  KILLED("Comando cancelado."),
  /**
   * O comando foi perdido.
   */
  LOST("Comando perdido."),
  /**
   * O comando terminou, mas no foi possvel ler o cdigo de retorno, para
   * determinar se foi bem sucedido.
   */
  NO_EXIT_CODE("No foi possvel determinar se o comando foi executado com sucesso.");

  private String description;

  private CommandFinalizationType(String description) {
    this.description = description;
  }

  public String getDescription() {
    return description;
  }

}
