/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ProjectFileType;

public abstract class ProjectFileTypeFilter {
    public abstract boolean accept(ProjectFileType var1);

    public static ProjectFileTypeFilter all() {
        return new ProjectFileTypeFilter(){

            @Override
            public boolean accept(ProjectFileType type) {
                return true;
            }
        };
    }

    public static ProjectFileTypeFilter directories() {
        return ProjectFileTypeFilter.directory(true);
    }

    public static ProjectFileTypeFilter files() {
        return ProjectFileTypeFilter.directory(false);
    }

    public static ProjectFileTypeFilter none() {
        return new ProjectFileTypeFilter(){

            @Override
            public boolean accept(ProjectFileType type) {
                return false;
            }
        };
    }

    public static ProjectFileTypeFilter directory(final boolean directory) {
        return new ProjectFileTypeFilter(){

            @Override
            public boolean accept(ProjectFileType type) {
                if (type == null) {
                    return false;
                }
                return type.isDirectory() == directory;
            }
        };
    }

    public static ProjectFileTypeFilter typeCode(final String typeCode) {
        return new ProjectFileTypeFilter(){

            @Override
            public boolean accept(ProjectFileType type) {
                if (type == null) {
                    return false;
                }
                return type.getCode().equals(typeCode);
            }
        };
    }

    public static ProjectFileTypeFilter or(final ProjectFileTypeFilter ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("filters.length == 0");
        }
        return new ProjectFileTypeFilter(){

            @Override
            public boolean accept(ProjectFileType type) {
                for (ProjectFileTypeFilter filter : filters) {
                    if (!filter.accept(type)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ProjectFileTypeFilter and(final ProjectFileTypeFilter ... filters) {
        if (filters.length == 0) {
            throw new IllegalArgumentException("filters.length == 0");
        }
        return new ProjectFileTypeFilter(){

            @Override
            public boolean accept(ProjectFileType type) {
                for (ProjectFileTypeFilter filter : filters) {
                    if (filter.accept(type)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ProjectFileTypeFilter not(final ProjectFileTypeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        return new ProjectFileTypeFilter(){

            @Override
            public boolean accept(ProjectFileType type) {
                return !filter.accept(type);
            }
        };
    }
}

