/**
 * $Id: FileLockedException.java 68848 2007-10-10 18:45:37Z taciana $
 */
package csbase.exception.project;

import csbase.exception.CSBaseRuntimeException;

/**
 * Exceo gerada quando uma operao no pde ser efetuada porque um arquivo
 * afetado pela mesma se encontrava bloqueado.
 */
public class FileLockedException extends CSBaseRuntimeException {

  /** Nome do arquivo bloqueado */
  private String lockedFileName;
  /** Indica se  um diretrio */
  private boolean isDirectory;
  
  /**
   * Cria uma nova exceo.
   * @param fileName nome do arquivo bloqueado
   * @param isDirectory indica se  o arquivo bloqueado um diretrio
   */
  public FileLockedException(String fileName, boolean isDirectory) {
    super("Arquivo bloqueado: " + fileName);
    this.lockedFileName = fileName;
    this.isDirectory = isDirectory;
  }

  /**
   * Retorna o nome do arquivo que causou a exceo.
   * 
   * @return nome do arquivo que causou a exceo
   */
  public String getLockedFileName() {
    return lockedFileName == null ? "" : lockedFileName;
  }
  
  /**
   * Retorna flag indicando se o arquivo bloqueado  um diretrio.
   * 
   * @return flag indicando se o arquivo bloqueado  um diretrio
   */
  public boolean isDirectory() {
    return isDirectory;
  }
}
