package csbase.logic.algorithms.flows;

import java.io.Serializable;

/**
 * <p>Parmetro de conexo.</p>
 * 
 * @author lmoreira
 */
public final class LinkParameter implements Serializable, Cloneable {

  /**
   * O rtulo do parmetro.
   */
  private String label;
  
  /**
   * O nome do parmetro.
   */
  private String name;
  
  /**
   * O identificador do n.
   */
  private int nodeId;

  /**
   * Cria um parmetro de conexo.
   * 
   * @param nodeId O identificador do n.
   * @param name O nome do parmetro (No aceita {@code null}).
   * @param label O rtulo do parmetro (No aceita {@code null}).
   */
  public LinkParameter(int nodeId, String name, String label) {
    super();
    setNodeId(nodeId);
    setName(name);
    setLabel(label);
  }

  @Override
  public LinkParameter clone() {
    try {
      return (LinkParameter) super.clone();
    }
    catch (CloneNotSupportedException e) {
      throw new IllegalStateException(e);
    }
  }
  
  
  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    LinkParameter other = (LinkParameter) obj;
    if (!this.name.equals(other.name)) {
      return false;
    }
    if (this.nodeId != other.nodeId) {
      return false;
    }
    return true;
  }

  /**
   * Obtm o rtulo.
   * 
   * @return O rtulo.
   */
  public String getLabel() {
    return this.label;
  }

  /**
   * Obtm o nome.
   * 
   * @return O nome.
   */
  public String getName() {
    return this.name;
  }

  /**
   * Obtm o identificador do n.
   * 
   * @return O identificador do n.
   */
  public int getNodeId() {
    return this.nodeId;
  }

  @Override
  public int hashCode() {
    final int PRIME = 31;
    int result = 1;
    result = PRIME * result + this.name.hashCode();
    result = PRIME * result + this.nodeId;
    return result;
  }

  /**
   * Atribui o rtulo a este parmetro.
   * 
   * @param label O rtulo (No aceita {@code null}).
   */
  private void setLabel(String label) {
    if (label == null) {
      throw new IllegalArgumentException("O parmetro label est nulo.");
    }
    this.label = label;
  }

  /**
   * Atribui o nome a este parmetro.
   * 
   * @param name O nome (No aceita {@code null}).
   */
  private void setName(String name) {
    if (name == null) {
      throw new IllegalArgumentException("O parmetro name est nulo.");
    }
    this.name = name;
  }

  /**
   * Atribui o identificador do n a este parmetro.
   * 
   * @param nodeId O identificador do n.
   */
  private void setNodeId(int nodeId) {
    this.nodeId = nodeId;
  }
}
