package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;

/**
 * <p>
 * Analisador de {@link DoubleListParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "lista de reais".O elemento
 * corrente do {@link XmlParser analisador de XML} precisa ser um elemento
 * {@link DoubleListParameter}.
 * </p>
 */
public class DoubleListParameterFactory extends
  SimpleParameterParser<DoubleListParameter> implements
  DoubleStructureAttributes {

  /**
   * <p>
   * O elemento {@value #DOUBLE_LIST_PARAMETER_ELEMENT}: descreve as
   * propriedades de um {@link DoubleListParameter parmetro do tipo lista de
   * reais}.
   * </p>
   * <p>
   *  filho do elemento {@link ParameterGroup}.
   * </p>
   */
  public static final String DOUBLE_LIST_PARAMETER_ELEMENT = "lista_de_reais";

  /**
   * {@inheritDoc}
   */
  @Override
  public DoubleListParameter createSimpleParameter(XmlParser parser,
    ParsedSimpleParameter definition, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    Double maximum =
      definition.getAttributeValue(DOUBLE_ELEMENT_MAXIMUM_ATTRIBUTE);
    boolean isMaximumIncluded =
      definition.getAttributeValue(DOUBLE_ELEMENT_INCLUDE_MAXIMUM_ATTRIBUTE);
    Double minimum =
      definition.getAttributeValue(DOUBLE_ELEMENT_MINIMUM_ATTRIBUTE);
    boolean isMinimumIncluded =
      definition.getAttributeValue(DOUBLE_ELEMENT_INCLUDE_MINIMUM_ATTRIBUTE);
    return new DoubleListParameter(definition.getName(), definition.getLabel(),
      definition.getDescription(), null, definition.isOptional(),
      definition.isVisible(), definition.getCommandLinePattern(), maximum,
      isMaximumIncluded, minimum, isMinimumIncluded);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<DoubleListParameter> getParameterStructure() {
    return getDoubleStructure(DOUBLE_LIST_PARAMETER_ELEMENT,
      DoubleListParameter.class);
  }
}
