package csbase.logic.algorithms.parsers;

import static csbase.logic.algorithms.parsers.TextSctructureAttributes
  .TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE;
import static csbase.logic.algorithms.parsers.TextSctructureAttributes
  .TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;

/**
 * <p>
 * Analisador de {@link TextListParameter}.
 * </p>
 *
 * <p>
 * Este parser l os atributos de parmetros do tipo "lista de textos". O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento {@link TextListParameter}.
 * </p>
 */
public class TextListParameterFactory extends
  SimpleParameterParser<TextListParameter> {

  /**
   * Nome do parmetro.
   */
  public static final String TEXT_LIST_PARAMETER_ELEMENT = "lista_de_texto";

  /**
   * {@inheritDoc}
   */
  @Override
  public TextListParameter createSimpleParameter(XmlParser parser,
    ParsedSimpleParameter definition, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    Integer maxCharacters =
      definition.getAttributeValue(TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE);
    return new TextListParameter(definition.getName(), definition.getLabel(),
      definition.getDescription(), null, definition.isOptional(),
      definition.isVisible(), definition.getCommandLinePattern(),
      maxCharacters);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ParameterStructure<TextListParameter> getParameterStructure() {
    ParameterStructure<TextListParameter> textStructure =
      new SimpleParameterStructure<>(TEXT_LIST_PARAMETER_ELEMENT,
        TextListParameter.class);
    textStructure.addAttribute(
      new IntegerAttribute(TEXT_ELEMENT_MAXIMUM_CHARACTERS_ATTRIBUTE, null,
        TEXT_ELEMENT_MAXIMUM_CHARACTERS_MINIMUM_VALUE, null));
    return textStructure;
  }
}
