/*
 * $Id$
 */
package csbase.logic.algorithms.xml.algorithmspack;

import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.List;

import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLBasicElement;
import tecgraf.javautils.xml.XMLElementInterface;

/**
 * Esta classe implementa o elemento XML que representa um conjunto de
 * propriedades.
 * 
 */
public class XMLPropertySetElement extends XMLBasicElement {
  /**
   * Mapa de valores para as propriedades
   */
  private Hashtable<String, String> propertyValues;

  /**
   * Retorna o mapa de valores para as propriedades.
   * 
   * @return um mapa com os valores das propriedades
   */
  public Hashtable<String, String> getPropertyValues() {
    return propertyValues;
  }

  /**
   * Constri o elemento xml que descreve uma propriedade.
   */
  public XMLPropertySetElement() {
    super();
    setTag(XmlAlgorithmsPackUtils.PROPERTIES_TAG);
    propertyValues = new Hashtable<String, String>();
  }

  /**
   * Executado quando a tag de fim do elemento XML  encontrada. Deve-se criar o
   * objeto correspondente na camada da aplicao.
   * 
   * @see tecgraf.javautils.xml.XMLElementInterface#endTag(java.util.List)
   */
  @Override
  public void endTag(List<XMLElementInterface> childrenList) {
    String name = null, value = null;
    ImprovedXMLListIterator iterator =
      new ImprovedXMLListIterator(childrenList);

    while (iterator.hasNext()) {
      XMLElementInterface nextElem = iterator.next();
      if (isPropertyElement(nextElem)) {
        name = getPropertyName(nextElem);
        value = getPropertyValue(nextElem);
        if (name != null && value != null) {
          propertyValues.put(name, value);
        }
      }
    }
  }

  /**
   * Verifica se  o elemento que representa uma propriedade.
   * 
   * @param xmlElem elemento xml
   * @return retorna true se o elemento representa uma propriedade, caso
   *         contrrio, retorna false
   */
  private boolean isPropertyElement(XMLElementInterface xmlElem) {
    return xmlElem.getTag().equals(XmlAlgorithmsPackUtils.PROPERTY_TAG);
  }

  /**
   * Obtm o nome da propriedade a partir do elemento xml especificado.
   * 
   * @param xmlElem elemento xml que especifica a propriedade
   * @return o nome da propriedade
   */
  private String getPropertyName(XMLElementInterface xmlElem) {
    return xmlElem
      .getAttributeStrValue(XmlAlgorithmsPackUtils.PROPERTY_NAME_ATTR);
  }

  /**
   * Obtm o valor da propriedade a partir do elemento xml especificado.
   * 
   * @param xmlElem elemento xml que especifica a propriedade
   * @return o valor da propriedade
   */
  private String getPropertyValue(XMLElementInterface xmlElem) {
    return xmlElem
      .getAttributeStrValue(XmlAlgorithmsPackUtils.PROPERTY_VALUE_ATTR);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void write(Writer arg0, String arg1) throws IOException {
    // TODO Auto-generated method stub

  }

}
