package csbase.logic.filters;

import csbase.logic.ClientProjectFile;
import csbase.logic.ProjectFileFilter;

public final class ProjectFileNotFilter  implements ProjectFileFilter {

  private ProjectFileFilter filter;

  public ProjectFileNotFilter(ProjectFileFilter filter) {
    if (filter == null) {
      throw new IllegalArgumentException("filter == null");
    }
    this.filter = filter;
  }

  @Override
  public boolean accept(ClientProjectFile file) {
    return !filter.accept(file);
  }
}
