/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows;

import csbase.logic.algorithms.flows.LinkParameter;
import csbase.logic.algorithms.flows.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FlowLink
implements Serializable,
Cloneable {
    private int id;
    private LinkParameter input;
    private LinkParameter output;
    private List<Point> points;

    public FlowLink(int id, LinkParameter output, LinkParameter input, List<Point> points) {
        this.setId(id);
        this.setOutput(output);
        this.setInput(input);
        this.setPoints(points);
    }

    public FlowLink clone() {
        try {
            FlowLink clone = (FlowLink)super.clone();
            if (this.input != null) {
                clone.input = this.input.clone();
            }
            if (this.output != null) {
                clone.output = this.output.clone();
            }
            clone.points = new ArrayList<Point>(this.points.size());
            for (Point point : this.points) {
                clone.points.add(point.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlowLink other = (FlowLink)obj;
        return this.getId() == other.getId();
    }

    public int getId() {
        return this.id;
    }

    public LinkParameter getInput() {
        return this.input;
    }

    public LinkParameter getOutput() {
        return this.output;
    }

    public List<Point> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public int hashCode() {
        return this.getId();
    }

    private void setId(int id) {
        this.id = id;
    }

    private void setInput(LinkParameter input) {
        this.input = input;
    }

    private void setOutput(LinkParameter output) {
        this.output = output;
    }

    private void setPoints(List<Point> points) {
        if (points == null) {
            throw new IllegalArgumentException("O par\u00e2metro points est\u00e1 nulo.");
        }
        this.points = new ArrayList<Point>(points);
    }
}

