/*
 * $Id:$
 */

package csbase.exception.algorithms;

import csbase.exception.CSBaseException;
import csbase.logic.algorithms.AlgorithmVersionId;

/**
 * Exceo de algortimo no encontrado.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class AlgorithmVersionNotFoundException extends CSBaseException {

  /**
   * Construtor
   * 
   * @param algorithmName nome
   * @param versionId verso (id)
   */
  public AlgorithmVersionNotFoundException(String algorithmName,
    AlgorithmVersionId versionId) {
    super("A verso {0} do algoritmo {1} no est instalada no sistema.",
      versionId, algorithmName);
  }

}
