package csbase.logic;

import java.io.Serializable;
import java.util.List;

/**
 * Modela as listas com os projetos de um determinado usurio.
 */
public class ProjectSynchronizationListProjects implements Serializable {
  private List<UserProjectInfo> projectsServerA;
  private List<UserProjectInfo> projectsServerB;
  private boolean sameServer;

  public ProjectSynchronizationListProjects(
    List<UserProjectInfo> projectsServerA, List<UserProjectInfo> projectsServerB) {
    this.projectsServerA = projectsServerA;
    this.projectsServerB = projectsServerB;
  }

  /**
   * Retorna a lista de projetos do servidor origem.
   *
   * @return List
   */
  public List<UserProjectInfo> getProjectsServerA() {
    return projectsServerA;
  }

  /**
   * Retorna a lista de projetos do servidor destino.
   *
   * @return List
   */
  public List<UserProjectInfo> getProjectsServerB() {
    return projectsServerB;
  }

  public boolean isSameServer() {
    return sameServer;
  }

  public void setSameServer(boolean sameServer) {
    this.sameServer = sameServer;
  }
}
