/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TextListParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;

public class TextListParameterFactory
extends SimpleParameterParser<TextListParameter> {
    public static final String TEXT_LIST_PARAMETER_ELEMENT = "lista_de_texto";

    @Override
    public TextListParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Integer maxCharacters = (Integer)definition.getAttributeValue("maximo_de_caracteres");
        return new TextListParameter(definition.getName(), definition.getLabel(), definition.getDescription(), null, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), maxCharacters);
    }

    @Override
    public ParameterStructure<TextListParameter> getParameterStructure() {
        SimpleParameterStructure<TextListParameter> textStructure = new SimpleParameterStructure<TextListParameter>(TEXT_LIST_PARAMETER_ELEMENT, TextListParameter.class);
        textStructure.addAttribute(new IntegerAttribute("maximo_de_caracteres", null, 1, null));
        return textStructure;
    }
}

