package csbase.logic.algorithms.parameters;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Classe que contm a documentao de um parmetro.
 */
public class ParameterDocumentation {

  /** Ttulo do parmetro */
  private String title;
  /** Descrio do parmetro */
  private String description;
  /** Descrio dos atributos */
  private Map<String, String> attributes;

  /**
   * Constutor.
   */
  public ParameterDocumentation() {
    attributes = new LinkedHashMap<String, String>();
  }

  /**
   * Define o
   * 
   * @param title
   */
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Obtm o ttulo do parmetro.
   * 
   * @return o ttulo do parmetro.
   */
  public String getTitle() {
    return title;
  }

  /**
   * Define a descrio do parmetro.
   * 
   * @param description a descrio do parmetro.
   */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * Obtm a descrio do parmetro.
   * 
   * @return descrio de um atributo.
   */
  public String getDescription() {
    return description;
  }

  /**
   * Obtm a descrio de um atributo, dado seu nome.
   * 
   * @param attributeName nome do atributo.
   * @return descrio de um atributo.
   */
  public String getAttribute(String attributeName) {
    return attributes.get(attributeName);
  }

  /**
   * Adiciona a descrio de um atributo.
   * 
   * @param attributeName nome do atributo.
   * @param attributeDescription descrio do atributo.
   */
  public void addAttribute(String attributeName, String attributeDescription) {
    attributes.put(attributeName, attributeDescription);
  }

}
