/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.DefaultEnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parsers.EnumerationItemFactory;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ElementStructure;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedElement;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractEnumerationParameterParser<T extends SimpleParameter<?>>
extends SimpleParameterParser<T> {
    public static final String ENUMERATION_PARAMETER_ELEMENT = "enumeracao";
    public static final String ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE = "ordenar";
    public static final boolean ENUMERATION_ELEMENT_MUST_SORT_DEFAULT_VALUE = true;
    private EnumerationItemFactory enumerationItemFactory = new EnumerationItemFactory();

    protected AbstractEnumerationParameterParser() {
    }

    @Override
    public T createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String defaultItemId = (String)definition.getAttributeValue("padrao");
        boolean mustSort = (Boolean)definition.getAttributeValue(ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE);
        List<ParsedElement> children = definition.getChildren("item_de_enumeracao");
        List<Object> items = children != null ? this.loadEnumerationItems(children, definition.getName()) : new ArrayList();
        return this.createEnumerationParameter(parser, definition.getName(), definition.getLabel(), definition.getDescription(), definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), mustSort, items, defaultItemId);
    }

    public List<EnumerationItem> loadEnumerationItems(List<ParsedElement> definitions, String parameterName) throws ParseException {
        LinkedList<EnumerationItem> items = new LinkedList<EnumerationItem>();
        for (ParsedElement definition : definitions) {
            String description;
            String value;
            String label;
            String id = (String)definition.getAttributeValue("id");
            DefaultEnumerationItem enumerationItem = new DefaultEnumerationItem(id, label = (String)definition.getAttributeValue("rotulo"), value = (String)definition.getAttributeValue("valor"), description = (String)definition.getAttributeValue("dica"));
            if (items.contains(enumerationItem)) {
                throw new ParseException("O item {0} est\u00e1 duplicado na enumera\u00e7\u00e3o {1}.", enumerationItem.getId(), parameterName);
            }
            for (EnumerationItem item : items) {
                if (!enumerationItem.getLabel().equals(item.getLabel())) continue;
                throw new ParseException("O item {0} est\u00e1 duplicado na enumera\u00e7\u00e3o {1}.", enumerationItem.getLabel(), parameterName);
            }
            items.add(enumerationItem);
        }
        return items;
    }

    protected abstract T createEnumerationParameter(XmlParser var1, String var2, String var3, String var4, boolean var5, boolean var6, String var7, boolean var8, List<EnumerationItem> var9, String var10) throws ParseException;

    protected final EnumerationItemFactory getEnumerationItemFactory() {
        return this.enumerationItemFactory;
    }

    protected ParameterStructure<T> getEnumerationStructure(String tag, Class<T> parameterClass) {
        SimpleParameterStructure<T> structure = new SimpleParameterStructure<T>(tag, parameterClass);
        structure.addAttribute(new BooleanAttribute("selecao_multipla", false));
        structure.addAttribute(new BooleanAttribute(ENUMERATION_ELEMENT_MUST_SORT_ATTRIBUTE, true));
        structure.addAttribute(new StringAttribute("padrao", null));
        ElementStructure<EnumerationItem> elementItemStructure = new ElementStructure<EnumerationItem>("item_de_enumeracao", EnumerationItem.class);
        elementItemStructure.addAttribute(new StringAttribute("id"));
        elementItemStructure.addAttribute(new StringAttribute("rotulo"));
        elementItemStructure.addAttribute(new StringAttribute("valor"));
        elementItemStructure.addAttribute(new StringAttribute("dica", null));
        structure.addChild(elementItemStructure);
        return structure;
    }
}

