/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ChoicePermission;
import csbase.logic.Permission;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ClientRemoteLocator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationPermission
extends ChoicePermission {
    private static final String APPLICATIONS = "APPLICATIONS";
    private static final String ALL = "#####";

    public ApplicationPermission() {
    }

    public ApplicationPermission(String name, String description, Map<?, ?> attributes) {
        super(name, description, attributes);
    }

    @Override
    public Map<String, Object> getDomain() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(APPLICATIONS, true);
        return map;
    }

    @Override
    public Map<String, Object> getRange(String attribute) throws Exception {
        LinkedHashMap<String, String> range = new LinkedHashMap<String, String>();
        Hashtable<String, ApplicationRegistry> applicationRegistries = ClientRemoteLocator.applicationService.getApplicationRegistries();
        Set<String> appIds = applicationRegistries.keySet();
        range.put(LNG.get((String)(this.getClass().getName() + ".types.all")), ALL);
        for (String id : appIds) {
            ApplicationRegistry registry = applicationRegistries.get(id);
            if (!range.containsKey(registry.getApplicationName(LNG.getLocale()))) {
                range.put(registry.getApplicationName(LNG.getLocale()), id);
                continue;
            }
            String oldId = (String)range.remove(registry.getApplicationName(LNG.getLocale()));
            range.put(this.formatRangeKey(oldId, registry.getApplicationName(LNG.getLocale())), oldId);
            range.put(this.formatRangeKey(id, registry.getApplicationName(LNG.getLocale())), id);
        }
        return range.entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareToIgnoreCase((String)e2.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
    }

    private String formatRangeKey(String appId, String appName) {
        return appName + " (" + appId + ")";
    }

    public static boolean userHasPermission(User user, String appId) throws Exception {
        boolean found = false;
        List<String> permissionClasses = ClientRemoteLocator.administrationService.getPermissionClasses();
        for (String className : permissionClasses) {
            if (!ApplicationPermission.class.getName().equals(className)) continue;
            found = true;
            break;
        }
        if (!found) {
            return true;
        }
        if (user.isAdmin()) {
            return true;
        }
        Vector<Object> permissionIds = user.getAllPermissionIds();
        HashSet<ApplicationPermission> permissions = new HashSet<ApplicationPermission>();
        for (Object object : permissionIds) {
            Permission p = Permission.getPermission(object);
            if (p == null || !(p instanceof ApplicationPermission) || permissions.contains(p)) continue;
            List applications = (List)((ApplicationPermission)p).getAttributes().get(APPLICATIONS);
            if (applications.contains(ALL) || applications.contains(appId)) {
                return true;
            }
            permissions.add((ApplicationPermission)p);
        }
        return false;
    }
}

