/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.EnvironmentVariable;
import csbase.logic.algorithms.parameters.FileListParameterListener;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.validators.FileListParameterValidator;
import csbase.logic.algorithms.parameters.validators.FileParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.core.lng.LNG;

public abstract class FileListParameter
extends ListParameter<FileURLValue> {
    private static String PATH = ".path";
    private static String TYPE = ".type";
    protected String[] fileTypes;
    protected transient List<FileListParameterListener> listeners = new LinkedList<FileListParameterListener>();
    private FileParameterMode mode;
    protected boolean usesFilter;
    private final boolean mustExist;

    public FileListParameter(String name, String label, String description, List<FileURLValue> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String[] fileTypes, FileParameterMode mode, boolean mustSort, boolean usesFilter, boolean mustExist) {
        super(name, label, description, defaultValue, isOptional, isVisible, mustSort, false, commandLinePattern);
        this.setFileTypes(fileTypes);
        this.usesFilter = usesFilter;
        this.mustExist = mustExist;
        this.setMode(mode);
    }

    public boolean mustWarnOverwrite() {
        return false;
    }

    public void addListener(FileListParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    @Override
    public Map<String, Object> exportValue() {
        HashMap valuesByName = new HashMap();
        LinkedList exportableValues = new LinkedList();
        List files = (List)this.getValue();
        if (files != null) {
            for (FileURLValue file : files) {
                HashMap<String, String> exportableValue = new HashMap<String, String>();
                exportableValue.put(PATH, file.getPath());
                exportableValue.put(TYPE, file.getType());
                exportableValues.add(Collections.unmodifiableMap(exportableValue));
            }
            valuesByName.put(this.getName(), Collections.unmodifiableCollection(exportableValues));
        }
        return Collections.unmodifiableMap(valuesByName);
    }

    @Override
    public String getCommandItemValue(CommandLineContext context, FileURLValue file) {
        char fileSeparator = context.getFileSeparator();
        if (file.getPath().startsWith(String.valueOf(fileSeparator))) {
            return file.getPath();
        }
        String path = file.getPath(fileSeparator);
        return CommandLineBuilder.makePathWithEnvironmentVariable(EnvironmentVariable.PROJECT_DIR, path, fileSeparator);
    }

    public String[] getFileTypes() {
        return this.fileTypes;
    }

    public FileParameterMode getMode() {
        return this.mode;
    }

    public boolean usesFilter() {
        return this.usesFilter;
    }

    @Override
    public String getValueAsText() {
        List files = (List)this.getValue();
        if (files == null || files.isEmpty()) {
            return null;
        }
        String separator = "";
        String valueAsText = "";
        for (FileURLValue file : files) {
            valueAsText = valueAsText + separator;
            valueAsText = valueAsText + file.getPath() + ":" + file.getType();
            separator = "|";
        }
        return valueAsText;
    }

    @Override
    public FileURLValue getItemValueFromText(String elementAsText) throws ParseException {
        String type;
        String path;
        Pattern withTypePattern = Pattern.compile("^(.+):(.+)$");
        Matcher withTypeMatcher = withTypePattern.matcher(elementAsText);
        if (withTypeMatcher.matches()) {
            path = withTypeMatcher.group(1);
            type = withTypeMatcher.group(2);
        } else {
            path = elementAsText;
            type = "UNKNOWN";
        }
        return new FileURLValue(path, type);
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        Collection exportableValues = (Collection)parameterValues.get(this.getName());
        if (exportableValues != null) {
            ArrayList<FileURLValue> files = new ArrayList<FileURLValue>();
            for (Map exportableValue : exportableValues) {
                String type;
                String path = (String)exportableValue.get(PATH);
                FileURLValue file = new FileURLValue(path, type = (String)exportableValue.get(TYPE));
                if (files.contains(file)) continue;
                files.add(file);
            }
            if (files.isEmpty()) {
                this.setValue(null);
            } else {
                this.setValue(files);
            }
        }
    }

    public void moveUp(int index) {
        List files = (List)this.getValue();
        if (files == null) {
            return;
        }
        int size = files.size();
        if (size == 0 || index == 0) {
            return;
        }
        FileURLValue element = (FileURLValue)files.remove(index);
        files.add(index - 1, element);
        this.fireValueWasChangedEvent();
    }

    public void moveDown(int index) {
        List files = (List)this.getValue();
        if (files == null) {
            return;
        }
        int size = files.size();
        if (size == 0 || index == size - 1) {
            return;
        }
        FileURLValue element = (FileURLValue)files.remove(index);
        files.add(index + 1, element);
        this.fireValueWasChangedEvent();
    }

    public boolean removeListener(FileListParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        return this.listeners.remove(listener);
    }

    public void setFileTypes(String[] fileTypes) {
        this.fileTypes = fileTypes != null ? fileTypes : new String[0];
        this.fireFileTypeWasChanged();
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        String[] components;
        if (parameterValue == null || parameterValue.length() == 0) {
            this.setValue(null);
            return;
        }
        ArrayList<FileURLValue> files = new ArrayList<FileURLValue>();
        for (String component : components = parameterValue.split("\\|")) {
            FileURLValue file = this.getItemValueFromText(component);
            files.add(file);
        }
        this.setValue(files);
    }

    private void fireFileTypeWasChanged() {
        for (FileListParameterListener listener : this.listeners) {
            listener.fileTypeWasChanged(this);
        }
    }

    protected void setMode(FileParameterMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "mode"));
        }
        this.mode = mode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<FileListParameterListener>();
    }

    public void setUsesFilter(boolean usesFilter) {
        this.usesFilter = usesFilter;
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    @Override
    public FileListParameterValidator createParameterValidator() {
        return new FileListParameterValidator(this.createItemValidator());
    }

    protected FileParameterValidator createItemValidator() {
        return new FileParameterValidator(this.isOptional());
    }

    public boolean mustExist() {
        return this.mustExist;
    }
}

