/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CommandFinalizationInfo;
import csbase.remote.RemoteEvent;

public final class CommandEvent
extends RemoteEvent {
    private Object commandId;
    private EventType type;
    private CommandFinalizationInfo finalizationInfo;
    private Integer elapsedTime;
    private Integer userTime;
    private Integer cpuTime;

    public CommandEvent(Object commandId, EventType type, CommandFinalizationInfo finalizationInfo) {
        this(commandId, type, finalizationInfo, null, null, null);
    }

    public CommandEvent(Object commandId, EventType type, CommandFinalizationInfo finalizationInfo, Integer elapsedTime, Integer userTime, Integer cpuTime) {
        this.commandId = commandId;
        this.type = type;
        this.finalizationInfo = finalizationInfo;
        this.setElapsedTime(elapsedTime);
        this.setUserTime(userTime);
        this.setCpuTime(cpuTime);
    }

    public CommandFinalizationInfo getFinalizationInfo() {
        return this.finalizationInfo;
    }

    public Object getCommandId() {
        return this.commandId;
    }

    public EventType getType() {
        return this.type;
    }

    public Integer getElapsedTime() {
        return this.elapsedTime;
    }

    public Integer getUserTime() {
        return this.userTime;
    }

    public Integer getCpuTime() {
        return this.cpuTime;
    }

    private void setElapsedTime(Integer elapsedTime) {
        if (elapsedTime != null && elapsedTime < 0) {
            throw new IllegalArgumentException("elapsedTime < 0 ");
        }
        this.elapsedTime = elapsedTime;
    }

    private void setUserTime(Integer userTime) {
        if (userTime != null && userTime < 0) {
            throw new IllegalArgumentException("userTime < 0 ");
        }
        this.userTime = userTime;
    }

    private void setCpuTime(Integer cpuTime) {
        if (cpuTime != null && cpuTime < 0) {
            throw new IllegalArgumentException("cpuTime < 0 ");
        }
        this.cpuTime = cpuTime;
    }

    public static enum EventType {
        LOST,
        KILLED,
        INIT_FAILURE,
        COMPLETED,
        ERROR,
        SUCCESS,
        NO_CODE;

    }
}

