/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.BooleanParameterValidator;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public final class BooleanParameter
extends SimpleParameter<Boolean> {
    public static final String TYPE = "BOOLEAN";
    private static final String DEFAULT_TRUE_COMMAND = "1";
    private static final String DEFAULT_FALSE_COMMAND = "0";
    private String trueCommand;
    private String falseCommand;

    public BooleanParameter(String name, String label, String description, boolean defaultValue, boolean isVisible, String commandLinePattern, String falseCommand, String trueCommand) {
        super(name, label, description, defaultValue, false, isVisible, commandLinePattern);
        this.setFalseCommand(falseCommand);
        this.setTrueCommand(trueCommand);
    }

    public void toggleValue() {
        Boolean value = (Boolean)this.getValue();
        this.setValue(new Boolean(value == false));
    }

    @Override
    public Object getExpressionValue() {
        return this.getValue();
    }

    public String getFalseCommand() {
        return this.falseCommand;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getTrueCommand() {
        return this.trueCommand;
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        if (parameterValue == null) {
            this.setValue(this.getDefaultValue());
        } else if (parameterValue.equals(Boolean.TRUE.toString())) {
            this.setValue(new Boolean(true));
        } else if (parameterValue.equals(Boolean.FALSE.toString())) {
            this.setValue(new Boolean(false));
        } else {
            throw new ParseException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidBooleanParameter"), this, parameterValue));
        }
    }

    @Override
    protected String getCommandValue(CommandLineContext context) {
        Boolean value = (Boolean)this.getValue();
        if (value.booleanValue()) {
            return this.getTrueCommand();
        }
        return this.getFalseCommand();
    }

    private void setFalseCommand(String falseCommand) {
        this.falseCommand = falseCommand == null ? DEFAULT_FALSE_COMMAND : falseCommand;
    }

    private void setTrueCommand(String trueCommand) {
        this.trueCommand = trueCommand == null ? DEFAULT_TRUE_COMMAND : trueCommand;
    }

    public BooleanParameterValidator createParameterValidator() {
        return new BooleanParameterValidator();
    }

    @Override
    public void setJSONValue(Object value) throws ParseException {
        if (value == null) {
            this.setValue(this.getDefaultValue());
        } else if (value instanceof Boolean) {
            this.setValue((Boolean)value);
        } else {
            throw new ParseException(MessageFormat.format("O valor {0} atribu\u00eddo ao par\u00e2metro {1} nao e um valor booleano valido.", this, value.toString()));
        }
    }
}

