/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.TextColumn;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.columns.AbstractTableColumnFactory;

public final class TextColumnFactory
extends AbstractTableColumnFactory {
    private static final String ELEMENT_NAME = "coluna_de_texto";

    public TextColumnFactory() {
        super(ELEMENT_NAME);
    }

    @Override
    public void setCellValue(XmlParser parser, String parameterName, TableColumn<?> column, int rowIndex, String valueAttributeName) {
        TextColumn textColumn = (TextColumn)column;
        String cellValue = parser.extractAttributeValue(valueAttributeName, null);
        textColumn.addDefaultValue(rowIndex, cellValue);
    }

    protected TextColumn createColumn(XmlParser parser, String parameterName, String label, String id, boolean isOptional, boolean isEditable, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String defaultValue = parser.extractAttributeValue("padrao", null);
        Integer maxCharacters = parser.extractAttributeValueAsInteger("maximo_de_caracteres", null, null, 1);
        parser.checkAttributes();
        parser.checkChildElements();
        return new TextColumn(id, label, defaultValue, isOptional, isEditable, maxCharacters);
    }
}

