/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import tecgraf.javautils.core.lng.LNG;

public final class AlgorithmVersionId
implements Serializable,
Comparable<AlgorithmVersionId>,
Cloneable {
    private static final String SEPARATOR = ".";
    private final int major;
    private final int minor;
    private final int patch;
    private final String stringValue;

    public AlgorithmVersionId(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        String sep = SEPARATOR;
        StringBuffer buf = new StringBuffer(String.valueOf(major));
        buf.append(SEPARATOR);
        buf.append(String.valueOf(minor));
        buf.append(SEPARATOR);
        buf.append(String.valueOf(patch));
        this.stringValue = buf.toString();
    }

    public static AlgorithmVersionId create(String versionText) {
        if (versionText == null) {
            String msg = MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "versionText");
            throw new IllegalArgumentException(msg);
        }
        StringTokenizer tokenizer = new StringTokenizer(versionText, SEPARATOR);
        try {
            String majorText = tokenizer.nextToken();
            String minorText = tokenizer.nextToken();
            String patchText = tokenizer.nextToken();
            int major = Integer.parseInt(majorText);
            int minor = Integer.parseInt(minorText);
            int patch = Integer.parseInt(patchText);
            return new AlgorithmVersionId(major, minor, patch);
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public AlgorithmVersionId clone() {
        try {
            return (AlgorithmVersionId)super.clone();
        }
        catch (CloneNotSupportedException e) {
            IllegalStateException ise = new IllegalStateException(LNG.get((String)"csbase.logic.algorithms.VersionNotclonable"));
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public int compareTo(AlgorithmVersionId other) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        AlgorithmVersionId other = (AlgorithmVersionId)o;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int[] getNumbers() {
        return new int[]{this.major, this.minor, this.patch};
    }

    public int hashCode() {
        return this.stringValue.hashCode();
    }

    public String toString() {
        return this.stringValue;
    }
}

