/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parsers.SimpleParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.SimpleParameterStructure;
import csbase.logic.algorithms.parsers.elements.attributes.IntegerAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringAttribute;

public class TextParameterFactory
extends SimpleParameterParser<TextParameter> {
    public static final String TEXT_PARAMETER_ELEMENT = "texto";

    @Override
    public TextParameter createSimpleParameter(XmlParser parser, ParsedSimpleParameter definition, ParameterGroup group, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String defaultValue = (String)definition.getAttributeValue("padrao");
        Integer maxCharacters = (Integer)definition.getAttributeValue("maximo_de_caracteres");
        return new TextParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), maxCharacters);
    }

    @Override
    public ParameterStructure<TextParameter> getParameterStructure() {
        SimpleParameterStructure<TextParameter> textStructure = new SimpleParameterStructure<TextParameter>(TEXT_PARAMETER_ELEMENT, TextParameter.class);
        textStructure.addAttribute(new IntegerAttribute("maximo_de_caracteres", null, 1, null));
        textStructure.addAttribute(new StringAttribute("padrao", null));
        return textStructure;
    }
}

