/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.AlgoEvent;
import csbase.logic.IdFactory;
import csbase.logic.IdInterface;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class CategorySet
implements Serializable {
    private SortedSet<Category> categories;
    private IdFactory idFactory;
    private boolean savedFlag;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public CategorySet() {
        this.categories = Collections.synchronizedSortedSet(new TreeSet());
        this.idFactory = new IdFactory(this.convertToList(this.getAllCategories()));
    }

    private List<? extends IdInterface> convertToList(SortedSet<Category> categorySet) {
        Vector<Category> categoryList = new Vector<Category>();
        categoryList.addAll(this.getAllCategories());
        return categoryList;
    }

    public CategorySet(SortedSet<Category> categories) {
        this.idFactory = new IdFactory(this.convertToList(this.getAllCategories()));
        this.categories = categories;
    }

    public SortedSet<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(SortedSet<Category> categories) {
        this.categories = categories;
    }

    public void addCategory(Category category) {
        this.categories.add(category);
    }

    public Category createCategory(Category parentCategory, String name) {
        Category category = new Category(parentCategory, this.getNextCategoryId(), name);
        if (parentCategory != null) {
            parentCategory.addCategory(category);
        } else {
            this.addCategory(category);
        }
        return category;
    }

    public void updateCategory(Category category) {
        Category currentCategory = this.getCategory(category.getId());
        if (currentCategory != null) {
            currentCategory.updateCategory(category);
        }
    }

    public Category removeCategory(String id) {
        return this.removeCategory(id, this.categories.iterator());
    }

    private Category removeCategory(String id, Iterator<Category> catIterator) {
        while (catIterator.hasNext()) {
            Category category = catIterator.next();
            if (category.getId().equals(id)) {
                this.freeAllSubCategories(category);
                catIterator.remove();
                this.idFactory.free(id);
                return category;
            }
            Category removedCategory = this.removeCategory(id, category.getCategories().iterator());
            if (removedCategory == null) continue;
            return removedCategory;
        }
        return null;
    }

    private void freeAllSubCategories(Category category) {
        for (Category subCat : category.getCategories()) {
            this.idFactory.free(subCat.getId());
            this.freeAllSubCategories(subCat);
        }
    }

    public void removeAllCategories() {
        this.categories.clear();
    }

    public Category getCategory(String id) {
        if (id == null) {
            return null;
        }
        return this.getCategory(id, this.categories);
    }

    public Category getRootCategory(String categoryId) {
        if (categoryId == null) {
            return null;
        }
        for (Category category : this.categories) {
            if (!category.getId().equals(categoryId)) continue;
            return category;
        }
        return null;
    }

    private Category getCategory(String id, SortedSet<Category> categories) {
        for (Category category : categories) {
            if (category.getId().equals(id)) {
                return category;
            }
            Category subCategory = this.getCategory(id, category.getCategories());
            if (subCategory == null) continue;
            return subCategory;
        }
        return null;
    }

    public void addAlgorithms(Category category, List<AlgorithmInfo> algorithms) {
        for (AlgorithmInfo algoInfo : algorithms) {
            category.addAlgorithm(algoInfo);
        }
    }

    public void addAlgorithmsToCategories(SortedSet<Category> categories, List<AlgorithmInfo> algorithms) {
        for (Category category : categories) {
            this.addAlgorithms(category, algorithms);
        }
    }

    public void removeAlgorithms(Category category, List<AlgorithmInfo> algorithms) {
        for (AlgorithmInfo algoInfo : algorithms) {
            category.removeAlgorithm(algoInfo);
        }
    }

    public void removeAlgorithmsFromCategories(SortedSet<Category> categories, List<AlgorithmInfo> algorithms) {
        for (Category removedCategory : categories) {
            this.removeAlgorithms(this.getCategory(removedCategory.getId()), algorithms);
        }
    }

    public boolean isEmpty() {
        return this.categories.isEmpty();
    }

    private String getNextCategoryId() {
        return String.valueOf(this.idFactory.next());
    }

    public static void update(AlgoEvent event) throws Exception {
        observable.notifyObservers(event);
    }

    public static void addObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void deleteObserver(Observer o) {
        observable.deleteObserver(o);
    }

    public int getSize() {
        return this.categories.size();
    }

    public SortedSet<Category> getAllCategories() {
        return this.getAllCategories(this.categories);
    }

    private SortedSet<Category> getAllCategories(SortedSet<Category> rootCategories) {
        TreeSet<Category> allCategories = new TreeSet<Category>();
        for (Category category : rootCategories) {
            allCategories.add(category);
            SortedSet<Category> subCategories = this.getAllCategories(category.getCategories());
            if (subCategories.isEmpty()) continue;
            allCategories.addAll(subCategories);
        }
        return allCategories;
    }

    public void setCategorySetSavedFlag(boolean state) {
        this.savedFlag = state;
    }

    public boolean isCategorySetSaved() {
        return this.savedFlag;
    }

    public void removeAllAlgorithmsFromCategories(SortedSet<Category> categories) {
        for (Category category : categories) {
            category.removeAllAlgorithms();
        }
    }

    public Category getFirstCategory() {
        return this.categories.first();
    }

    public void changeCategoryIds() {
        SortedSet<Category> allCategories = this.getCategories();
        for (Category category : allCategories) {
            this.generateCategoryId(category, null);
        }
    }

    private void generateCategoryId(Category category, Category parentCategory) {
        String catId = this.getNextCategoryId();
        category.setId(catId);
        category.setParentCategory(parentCategory);
        SortedSet<Category> subCategories = category.getCategories();
        for (Category subCat : subCategories) {
            this.generateCategoryId(subCat, category);
        }
    }

    public List<String> getAlgorithmCategoriesFullNames(AlgorithmInfo algoInfo) {
        Vector<String> categoriesPath = new Vector<String>();
        for (Category category : this.getAllCategories()) {
            if (!category.containsAlgorithm(algoInfo)) continue;
            categoriesPath.add(category.getFullName());
        }
        return categoriesPath;
    }

    public List<String> getAlgorithmCategoriesFullNames(String algoName) {
        Vector<String> categoriesPath = new Vector<String>();
        for (Category category : this.getAllCategories()) {
            if (!category.containsAlgorithm(algoName)) continue;
            categoriesPath.add(category.getFullName());
        }
        return categoriesPath;
    }

    public List<Category> getCategoriesFromFullNames(List<String> categoryFullNames) {
        Vector<Category> categories = new Vector<Category>();
        for (Category category : this.getAllCategories()) {
            if (!categoryFullNames.contains(category.getFullName())) continue;
            categories.add(category);
        }
        return categories;
    }

    public Category getCategory(String parentCategoryFullName, String catFullName) {
        if (parentCategoryFullName == null) {
            SortedSet<Category> rootCategories = this.getCategories();
            for (Category category : rootCategories) {
                if (!category.getFullName().equals(catFullName)) continue;
                return category;
            }
        } else {
            SortedSet<Category> allCategories = this.getAllCategories();
            for (Category category : allCategories) {
                Category parentCategory = category.getParentCategory();
                String currentParentFullName = parentCategory != null ? parentCategory.getFullName() : null;
                String currentCatName = category.getFullName();
                if (currentParentFullName == null || !currentParentFullName.equals(parentCategoryFullName) || !currentCatName.equals(catFullName)) continue;
                return category;
            }
        }
        return null;
    }
}

