/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.CommandLineParameterFormatter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public final class HiddenParameter
extends Parameter<String> {
    private String commandLinePattern;
    private String value;

    public HiddenParameter(String name, String value, String commandLinePattern) {
        super(name);
        this.setValue(value);
        this.setCommandLinePattern(commandLinePattern);
    }

    @Override
    public Map<String, Object> exportValue() {
        return new HashMap<String, Object>();
    }

    public String getCommandLine() {
        return CommandLineParameterFormatter.formatCommandLine(this.getName(), this.getValue(), this.getCommandLinePattern());
    }

    @Override
    public String getCommandLine(CommandLineContext context) {
        return this.getCommandLine();
    }

    public String getCommandLinePattern() {
        return this.commandLinePattern;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void importValue(Map<String, Object> values) {
    }

    @Override
    public boolean isSetDefaultValue() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public void resetValue() {
    }

    private void setCommandLinePattern(String commandLinePattern) {
        if (commandLinePattern == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "commandLinePattern"));
        }
        this.commandLinePattern = commandLinePattern;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "value"));
        }
        this.value = value;
    }

    @Override
    public Validation validate(ValidationContext context) {
        return new ValidationSuccess();
    }

    @Override
    public boolean setVisible(boolean isVisible) {
        return false;
    }
}

