/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.xml.category;

import csbase.exception.ServiceFailureException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import csbase.remote.ClientRemoteLocator;
import java.io.IOException;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import tecgraf.javautils.xml.ImprovedXMLListIterator;
import tecgraf.javautils.xml.XMLBasicElement;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLEmptyElement;

public class XmlCategoryElement
extends XMLBasicElement {
    private Category currentCategory;

    public XmlCategoryElement() {
        this.setTag("category");
    }

    public XmlCategoryElement(Category category) {
        this();
        this.currentCategory = category;
    }

    public void endTag(List<XMLElementInterface> childrenList) {
        this.currentCategory = this.createCategory();
        ImprovedXMLListIterator iterator = new ImprovedXMLListIterator(childrenList);
        XMLElementInterface nextElem = iterator.next("*");
        while (nextElem != null) {
            if (this.isAlgorithmElement(nextElem)) {
                this.addAlgorithmToCategory(nextElem);
            } else if (this.isCategoryElement(nextElem)) {
                this.addSubCategory(nextElem);
            }
            nextElem = iterator.next("*");
        }
    }

    private void addSubCategory(XMLElementInterface xmlElem) {
        Category subCategory = ((XmlCategoryElement)xmlElem).getCategory();
        if (subCategory != null) {
            subCategory.setParentCategory(this.currentCategory);
            this.currentCategory.addCategory(subCategory);
        }
    }

    private void addAlgorithmToCategory(XMLElementInterface xmlElem) {
        Object algorithmId = this.getAlgorithmId(xmlElem);
        AlgorithmInfo algorithmInfo = null;
        try {
            algorithmInfo = ClientRemoteLocator.algorithmService.getInfo(algorithmId);
            if (algorithmInfo != null) {
                this.currentCategory.addAlgorithm(algorithmInfo);
            } else {
                System.err.println("Algoritmo com id [" + algorithmId + "] n\u00e3o encontrado.");
            }
        }
        catch (RemoteException re) {
            throw new ServiceFailureException("Ocorreu um problema ao obter o algoritmo com id [" + algorithmId + "].", re);
        }
    }

    private boolean isAlgorithmElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("algorithm");
    }

    private boolean isCategoryElement(XMLElementInterface xmlElem) {
        return xmlElem.getTag().equals("category");
    }

    public Category getCategory() {
        return this.currentCategory;
    }

    private Category createCategory() {
        String id = this.getAttributeStrValue("id");
        String name = this.getAttributeStrValue("name");
        return new Category(id, name);
    }

    private Object getAlgorithmId(XMLElementInterface xmlElem) {
        if (this.isAlgorithmElement(xmlElem)) {
            return xmlElem.getAttributeStrValue("id");
        }
        return null;
    }

    private void writeAllAlgorithmElement(Writer writer, String ident) throws IOException {
        String newIdent = XMLBasicElement.getNextIdentation((String)ident);
        Set<AlgorithmInfo> algorithms = this.currentCategory.getAlgorithms();
        if (!algorithms.isEmpty()) {
            for (AlgorithmInfo algorithmInfo : algorithms) {
                this.writeAlgorithmElement(writer, newIdent, algorithmInfo);
            }
        }
    }

    private void writeAllSubCategoryElement(Writer writer, String ident) throws IOException {
        String newIdent = XMLBasicElement.getNextIdentation((String)ident);
        SortedSet<Category> subCategories = this.currentCategory.getCategories();
        if (!subCategories.isEmpty()) {
            for (Category category : subCategories) {
                this.writeSubCategoryElement(writer, newIdent, category);
            }
        }
    }

    private void writeSubCategoryElement(Writer writer, String ident, Category subCategory) throws IOException {
        XmlCategoryElement xmlcategory = new XmlCategoryElement(subCategory);
        xmlcategory.write(writer, ident);
    }

    private void writeAlgorithmElement(Writer writer, String ident, AlgorithmInfo algorithm) throws IOException {
        XMLEmptyElement xmlAlgoElement = new XMLEmptyElement();
        xmlAlgoElement.setTag("algorithm");
        String algoId = algorithm.getId();
        xmlAlgoElement.newAttribute("id", algoId);
        xmlAlgoElement.write(writer, ident);
    }

    public void write(Writer writer, String ident) throws IOException {
        String categoryId = this.currentCategory.getId();
        String categoryName = this.currentCategory.getName();
        this.newAttribute("id", categoryId);
        this.newAttribute("name", categoryName);
        this.writeStartTagln(writer, ident);
        this.writeAllSubCategoryElement(writer, ident);
        this.writeAllAlgorithmElement(writer, ident);
        this.writeEndTag(writer, ident);
    }
}

