package csbase.logic.diagnosticservice;

import java.io.Serializable;

/**
 * Dados de uma propriedade utilizada na monitorao do recurso.
 * 
 * @author Tecgraf PUC-Rio
 */
public class ResourceProperty implements Serializable {

  /**
   * Nome
   */
  public final String name;

  /**
   * Valor
   */
  public final String value;

  /**
   * Origem (opcional)
   */
  public final String source;

  /**
   * Construtor.
   * 
   * @param key nome da propriedade
   * @param value valor da propriedade
   * @param source origem (opcional) da propriedade
   */
  public ResourceProperty(String key, String value, String source) {
    this.name = key;
    this.value = value;
    this.source = source;
  }
}
