/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfoCache;
import csbase.logic.CommandStatus;
import csbase.logic.CommandSubmission;
import csbase.logic.Priority;
import csbase.logic.ProgressData;
import csbase.logic.ProgressDataParser;
import csbase.logic.SimpleCommandFinalizationInfo;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.ExecutionType;
import csbase.logic.algorithms.MonitoredFile;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import csbase.remote.ClientRemoteLocator;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CommandInfo
implements Serializable {
    private AlgorithmConfigurator configurator;
    private String description;
    private int globalPosition;
    private int submissionAttempts = 0;
    private String id;
    private boolean mailAtEnd;
    private String[] emailList;
    private Integer executionCountForMultipleExecution;
    private Integer executionCountPerSGAForMultipleExecution;
    private Double cpuPerc;
    private Double cpuTimeSec;
    private Double ramMemoryMB;
    private Double ramMemoryPerc;
    private Double swapMemoryMB;
    private Double swapMemoryPerc;
    private Map<String, String> specificData;
    private Integer wallTimeSec;
    private String executionNodeDescription;
    private Double userTimeSec;
    private Double systemTimeSec;
    private Double virtualMemorySizeMB;
    private Double bytesInKB;
    private Double bytesOutKB;
    private Double diskBytesReadKB;
    private Double diskBytesWriteKB;
    private Priority priority;
    private Object projectId;
    private String sgaName;
    private List<String> selectedSGAsNames;
    private CommandStatus status;
    private CommandFinalizationInfo finalizationInfo;
    private Date submittedDate;
    private String tip;
    private Object userId;
    private String platformFilter;
    private boolean isAutomatic;
    private ExecutionType executionType;
    private boolean isValid;
    private boolean isQueued;
    private transient ProgressData cachedProgressData;
    private String[] persistencyPath;
    private Lock statusLock = new ReentrantLock();
    private String clientHostName;
    private Map<String, String> extraPropertiesMap;
    private List<MonitoredFile> monitoredFiles;

    public CommandInfo(String id, int globalPosition, boolean mailAtEnd, Object projectId, Date submittedDate, Object userId, Priority priority, CommandStatus status, CommandFinalizationInfo finalizationInfo, String tip) {
        if (null == finalizationInfo) {
            try {
                throw new IllegalArgumentException("finalizationType");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.id = id;
        this.projectId = projectId;
        this.globalPosition = globalPosition;
        this.mailAtEnd = mailAtEnd;
        this.emailList = null;
        this.submittedDate = submittedDate;
        this.userId = userId;
        this.priority = priority;
        this.setStatus(status, finalizationInfo);
        this.selectedSGAsNames = new ArrayList<String>();
        this.tip = tip;
        this.isValid = true;
        this.isQueued = false;
        this.configureSimpleExecution();
    }

    public CommandInfo(String id, AlgorithmConfigurator configurator, CommandSubmission submission, String userId, Map<String, String> extraPropertiesMap) {
        this.clientHostName = submission.getClientHostName();
        this.configurator = configurator;
        this.projectId = submission.getProjectId();
        this.id = id;
        this.description = submission.getDescription();
        this.priority = submission.getPriority();
        this.mailAtEnd = submission.isMailAtEnd();
        this.emailList = submission.getEmailList();
        this.submittedDate = submission.getSubmittedDate();
        this.executionCountForMultipleExecution = submission.getExecutionCountForMultipleExecution();
        this.executionCountPerSGAForMultipleExecution = submission.getExecutionCountPerSGAForMultipleExecution();
        this.isAutomatic = submission.isAutomatic();
        this.platformFilter = submission.getPlatform();
        this.selectedSGAsNames = new ArrayList<String>(submission.getSGANames());
        this.executionType = submission.getExecutionType();
        this.tip = configurator.toString();
        this.userId = userId;
        this.setStatus(CommandStatus.SCHEDULED, new SimpleCommandFinalizationInfo(CommandFinalizationType.NOT_FINISHED, false));
        this.isValid = true;
        this.isQueued = false;
        this.extraPropertiesMap = extraPropertiesMap;
    }

    public void invalidateDynamicFields() {
        this.cpuPerc = null;
        this.cpuTimeSec = null;
        this.ramMemoryPerc = null;
        this.swapMemoryPerc = null;
        this.wallTimeSec = null;
        this.executionNodeDescription = null;
        this.specificData = null;
        this.userTimeSec = null;
        this.systemTimeSec = null;
        this.virtualMemorySizeMB = null;
        this.bytesInKB = null;
        this.bytesOutKB = null;
        this.diskBytesReadKB = null;
        this.diskBytesWriteKB = null;
        this.isValid = false;
        this.isQueued = false;
    }

    public boolean isQueued() {
        return this.isQueued;
    }

    public void setQueued(boolean isQueued) {
        this.isQueued = isQueued;
    }

    public void validateDynamicFields() {
        this.isValid = true;
    }

    public Double getCpuPerc() {
        return this.cpuPerc;
    }

    public void setCpuPerc(Double cpuPerc) {
        this.cpuPerc = cpuPerc;
    }

    public Double getCpuTimeSec() {
        return this.cpuTimeSec;
    }

    public void setCpuTimeSec(Double cpuTimeSec) {
        this.cpuTimeSec = cpuTimeSec;
    }

    public Double getRAMMemoryMB() {
        return this.ramMemoryMB;
    }

    public void setRAMMemoryMB(Double ramMemoryMB) {
        this.ramMemoryMB = ramMemoryMB;
    }

    public Double getRAMMemoryPerc() {
        return this.ramMemoryPerc;
    }

    public void setRAMMemoryPerc(Double ramMemoryPerc) {
        this.ramMemoryPerc = ramMemoryPerc;
    }

    public Double getSwapMemoryMB() {
        return this.swapMemoryMB;
    }

    public void setSwapMemoryMB(Double swapMemoryMB) {
        this.swapMemoryMB = swapMemoryMB;
    }

    public Double getSwapMemoryPerc() {
        return this.swapMemoryPerc;
    }

    public void setSwapMemoryPerc(Double swapMemoryPerc) {
        this.swapMemoryPerc = swapMemoryPerc;
    }

    public Map<String, String> getSpecificData() {
        return this.specificData;
    }

    public void setSpecificData(Map<String, String> specificData) {
        this.specificData = specificData;
        this.cachedProgressData = null;
    }

    public Integer getWallTimeSec() {
        return this.wallTimeSec;
    }

    public void setWallTimeSec(Integer wallTimeSec) {
        this.wallTimeSec = wallTimeSec;
    }

    public Double getSystemTimeSec() {
        return this.systemTimeSec;
    }

    public void setSystemTimeSec(Double systemTimeSec) {
        this.systemTimeSec = systemTimeSec;
    }

    public Double getVirtualMemorySizeMB() {
        return this.virtualMemorySizeMB;
    }

    public void setVirtualMemorySizeMB(Double virtualMemorySizeMB) {
        this.virtualMemorySizeMB = virtualMemorySizeMB;
    }

    public Double getBytesInKB() {
        return this.bytesInKB;
    }

    public void setBytesInKB(Double bytesInKB) {
        this.bytesInKB = bytesInKB;
    }

    public Double getBytesOutKB() {
        return this.bytesOutKB;
    }

    public void setBytesOutKB(Double bytesOutKB) {
        this.bytesOutKB = bytesOutKB;
    }

    public Double getDiskBytesReadKB() {
        return this.diskBytesReadKB;
    }

    public void setDiskBytesReadKB(Double diskBytesReadKB) {
        this.diskBytesReadKB = diskBytesReadKB;
    }

    public Double getDiskBytesWriteKB() {
        return this.diskBytesWriteKB;
    }

    public void setDiskBytesWriteKB(Double diskBytesWriteKB) {
        this.diskBytesWriteKB = diskBytesWriteKB;
    }

    public void setUserTimeSec(Double userTimeSec) {
        this.userTimeSec = userTimeSec;
    }

    public Double getUserTimeSec() {
        return this.userTimeSec;
    }

    public String getExecutionNodeDescription() {
        return this.executionNodeDescription;
    }

    public void setExecutionNodeDescription(String executionNodeDescription) {
        this.executionNodeDescription = executionNodeDescription;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMailAtEnd(boolean mailAtEnd) {
        this.mailAtEnd = mailAtEnd;
    }

    public void setExecutionCountForMultipleExecution(Integer executionCountForMultipleExecution) {
        this.executionCountForMultipleExecution = executionCountForMultipleExecution;
    }

    public void setExecutionCountPerSGAForMultipleExecution(Integer executionCountPerSGAForMultipleExecution) {
        this.executionCountPerSGAForMultipleExecution = executionCountPerSGAForMultipleExecution;
    }

    public void setProjectId(Object projectId) {
        this.projectId = projectId;
    }

    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    public void setUserId(Object userId) {
        this.userId = userId;
    }

    public void setAutomatic(boolean isAutomatic) {
        this.isAutomatic = isAutomatic;
    }

    public void setExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
    }

    public void configureMultipleExecution(int executionCount) {
        this.executionType = ExecutionType.MULTIPLE;
        this.isAutomatic = true;
        this.executionCountForMultipleExecution = executionCount;
    }

    public void configureMultipleExecution(List<String> sgaNames, int executionCountPerSGA) {
        this.executionType = ExecutionType.MULTIPLE;
        this.isAutomatic = false;
        this.setSelectedSGAsNames(sgaNames);
        this.executionCountPerSGAForMultipleExecution = executionCountPerSGA;
        this.executionCountForMultipleExecution = executionCountPerSGA * this.selectedSGAsNames.size();
    }

    public void configureSimpleExecution() {
        this.executionType = ExecutionType.SIMPLE;
        this.isAutomatic = true;
    }

    public void configureSimpleExecution(String sgaName) {
        this.executionType = ExecutionType.SIMPLE;
        this.isAutomatic = false;
        this.setSelectedSGAName(sgaName);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CommandInfo)) {
            return false;
        }
        if (this.id == null) {
            return false;
        }
        CommandInfo other = (CommandInfo)obj;
        return this.id.equals(other.id);
    }

    public AlgorithmConfigurator getConfigurator() throws RemoteException {
        if (this.configurator == null) {
            this.configurator = ClientRemoteLocator.commandPersistenceService.readAlgorithmConfigurator(this.getProjectId(), this.getId());
        }
        return this.configurator;
    }

    public String getDescription() {
        return this.description;
    }

    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    public int getGlobalPosition() {
        return this.globalPosition;
    }

    public String getId() {
        return this.id;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public Object getProjectId() {
        return this.projectId;
    }

    public String getSGAName() {
        return this.sgaName;
    }

    public List<String> getSelectedSGAsNames() {
        return Collections.unmodifiableList(this.selectedSGAsNames);
    }

    public void setSelectedSGAsNames(List<String> selectedSGAsNames) {
        this.selectedSGAsNames.clear();
        this.selectedSGAsNames.addAll(selectedSGAsNames);
    }

    public CommandStatus getStatus() {
        return this.status;
    }

    public CommandFinalizationType getFinalizationType() {
        if (null == this.finalizationInfo || null == this.finalizationInfo.getFinalizationType()) {
            return CommandStatus.FINISHED == this.status ? CommandFinalizationType.UNKNOWN : CommandFinalizationType.NOT_FINISHED;
        }
        return this.finalizationInfo.getFinalizationType();
    }

    public boolean hasWarnings() {
        if (null == this.finalizationInfo || null == this.finalizationInfo.getFinalizationType() || this.finalizationInfo.getFinalizationType() == CommandFinalizationType.NOT_FINISHED) {
            return false;
        }
        return this.finalizationInfo.hasWarnings();
    }

    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    public Integer getExecutionCountForMultipleExecution() {
        return this.executionCountForMultipleExecution;
    }

    public Integer getExecutionCountPerSGAForMultipleExecution() {
        return this.executionCountPerSGAForMultipleExecution;
    }

    public Object getUserId() {
        return this.userId;
    }

    public int hashCode() {
        if (this.id == null) {
            return "CommandInfoWhitoutId".hashCode();
        }
        return this.id.hashCode();
    }

    public boolean isMailAtEnd() {
        return this.mailAtEnd;
    }

    public String[] getEmailList() {
        return this.emailList;
    }

    public String print() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("id: " + this.id + "\n");
        buffer.append("tip: " + this.getTip() + "\n");
        buffer.append("description: " + this.description + "\n");
        buffer.append("sgaName: " + this.sgaName + "\n");
        buffer.append("userId: " + this.userId + "\n");
        return buffer.toString();
    }

    public void setGlobalPosition(int globalPosition) {
        this.globalPosition = globalPosition;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public void setSGAName(String sgaName) {
        this.sgaName = sgaName;
    }

    public boolean setStatus(CommandStatus status) {
        if (CommandStatus.FINISHED == status) {
            return this.setStatus(status, new SimpleCommandFinalizationInfo(CommandFinalizationType.UNKNOWN, false));
        }
        return this.setStatus(status, new SimpleCommandFinalizationInfo(CommandFinalizationType.NOT_FINISHED, false));
    }

    public void setFinished(CommandFinalizationInfo info) {
        this.setStatus(CommandStatus.FINISHED, info);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        return this.id + " ( " + this.getTip() + " )";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setStatus(CommandStatus status, CommandFinalizationInfo info) {
        if (null == status) {
            throw new IllegalArgumentException(String.format("Atribuindo estado nulo ao comando %s.", this.id));
        }
        if (null == info) {
            throw new IllegalArgumentException(String.format("Atribuindo estado de t\u00e9rmino nulo ao comando %s.", this.id));
        }
        CommandFinalizationType finalizationType = info.getFinalizationType();
        if (CommandStatus.FINISHED == status && CommandFinalizationType.NOT_FINISHED == finalizationType || CommandStatus.FINISHED != status && CommandStatus.SYSTEM_FAILURE != status && CommandFinalizationType.NOT_FINISHED != finalizationType) {
            throw new IllegalArgumentException(String.format("Atribuindo estado inconsistente ao comando %s. CommandStatus: %s e CommandFinalisationType: %s", new Object[]{this.id, status, finalizationType}));
        }
        this.statusLock.lock();
        try {
            if (this.status == CommandStatus.FINISHED) {
                boolean bl = false;
                return bl;
            }
            this.status = status;
            this.finalizationInfo = info;
            boolean bl = true;
            return bl;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    private void setSelectedSGAName(String selectedSGAName) {
        this.setSelectedSGAsNames(Arrays.asList(selectedSGAName));
    }

    public String getPlatformFilter() {
        return this.platformFilter;
    }

    public Map<String, String> getExtraPropertiesMap() {
        return this.extraPropertiesMap;
    }

    public boolean isAutomatic() {
        return this.isAutomatic;
    }

    public String getTip() {
        return this.tip;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPlatformFilter(String platformFilter) {
        this.platformFilter = platformFilter;
    }

    public ProgressData getProgressData() {
        switch (this.status) {
            case EXECUTING: {
                return this.getExecutingCommandProgress();
            }
            case FINISHED: 
            case SYSTEM_FAILURE: 
            case DOWNLOADING: {
                return new ProgressData("100%");
            }
            case INIT: 
            case SCHEDULED: 
            case UPLOADING: {
                return new ProgressData("0%");
            }
        }
        return null;
    }

    public ProgressData getExecutingCommandProgress() {
        int expectedValues;
        if (this.cachedProgressData != null) {
            return this.cachedProgressData;
        }
        if (this.specificData == null) {
            return new ProgressData(0.0);
        }
        ProgressDataParser progressDataParser = new ProgressDataParser();
        if (!progressDataParser.hasProgressData(this.specificData)) {
            return new ProgressData(0.0);
        }
        AlgorithmConfigurator.ConfiguratorType configuratorType = this.configurator.getConfiguratorType();
        if (configuratorType.equals((Object)AlgorithmConfigurator.ConfiguratorType.FLOW)) {
            FlowAlgorithmConfigurator flowConfigurator = (FlowAlgorithmConfigurator)this.configurator;
            expectedValues = flowConfigurator.getNodes().size();
        } else {
            expectedValues = 1;
        }
        ProgressData data = progressDataParser.extractOverallProgressData(this.specificData, expectedValues);
        if (data != null) {
            this.cachedProgressData = data;
        }
        return data;
    }

    public Map<Integer, ProgressData> getProgressDataMap() {
        ProgressDataParser progressDataParser = new ProgressDataParser();
        return progressDataParser.extractProgressDataMap(this.specificData);
    }

    public String[] getPersistencyPath() {
        return this.persistencyPath;
    }

    public void setPersistencyPath(String[] persistencyPath) {
        this.persistencyPath = persistencyPath;
    }

    public CommandFinalizationInfo getFinalizationInfo() {
        return this.finalizationInfo;
    }

    public synchronized Integer getSubmissionAttempts() {
        return this.submissionAttempts;
    }

    public synchronized void incSubmissionAttempts() {
        ++this.submissionAttempts;
    }

    public Object readResolve() {
        return CommandInfoCache.getInstance().getCommandInfo(this);
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public List<MonitoredFile> getMonitoredFiles() {
        if (this.monitoredFiles == null) {
            return Collections.EMPTY_LIST;
        }
        return this.monitoredFiles;
    }

    public void setMonitoredFiles(List<MonitoredFile> monitoredFiles) {
        this.monitoredFiles = monitoredFiles;
    }
}

