/*
 * $Id: NoHiddenFileFilter.java 106925 2010-06-14 23:13:55Z jnlopes $
 */
package csbase.logic;

/**
 * Filtro que aceita apenas arquivos cujos nomes no comeam com ".".
 */
public class NoHiddenFileFilter implements ProjectFileFilter {

  /**
   * Instncia nica da classe.
   */
  private static NoHiddenFileFilter instance;

  /**
   * Construtor.
   */
  private NoHiddenFileFilter() {
    // vazio
  }

  /**
   * Retorna a instncia (nica) da classe.
   * 
   * @return instncia (nica) da classe
   */
  public static NoHiddenFileFilter getInstance() {
    if (instance == null) {
      instance = new NoHiddenFileFilter();
    }
    return instance;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean accept(ClientProjectFile file) {
    return file.getName().charAt(0) != '.';
  }

}
