package csbase.logic;

/**
 * 
 * Esconde um ou mais projetos da listagem de abertura.  uma permisso um pouco diferente das outras, 
 * pois revoga o direito a algo, ao invs de permitir algo. Para que um usurio tenha algum projeto escondido, 
 * deve-se dizer o nome dos projetos no campo atributo.
 * 
 *  Para isso, voc pode definir o atributo:
 * 
 * - {@code projeto=<nome_do_projeto>} : representa o nome do projeto que ser invisvel para esse usurio
 * 
 */
public class RevokeProjectPermission extends AttributesPermission {
  /** Atributo que define o nome do projeto */
  public static final String PROJECT_ID = "projeto=";

  /**
   * Constri uma permisso para escrita no projeto.
   */
  public RevokeProjectPermission() {
    super();
  }

  /**
   * Constri uma permisso para escrita no projeto.
   * 
   * @param name nome da permisso
   * @param description descrio
   * @param attributes atributos da permisso
   */
  public RevokeProjectPermission(String name, String description,
    String[] attributes) {
    super(name, description, attributes);
  }

  /**
   * Verifica se o usurio tem permisso que revoga acesso a um projeto
   * 
   * @param user usurio que solicita a permisso de invisibilidade
   * @param projectName nome do projeto
   * 
   * @return retorna true se o usurio tem permisso
   *         que esconde o projeto, caso contrrio, retorna false
   * @throws Exception erro ocorrido durante a busca pela permisso (ex: de rmi)
   * 
   */
  public static boolean checkPermission(User user, String projectName) {
    boolean hasPermission = false;
    // Cria o atributo que indica o sistema que originou a chamada
    String projectAttribute = RevokeProjectPermission.PROJECT_ID + projectName;

    String[] attributes = new String[] { projectAttribute };
    RevokeProjectPermission revokeOnlyProjectPermission = null;
    try {
      revokeOnlyProjectPermission =
        (RevokeProjectPermission) user.getMatchAttributesPermission(
          RevokeProjectPermission.class, attributes);
    }
    catch (Exception e) {
      throw new RuntimeException(e);
    }
    if (revokeOnlyProjectPermission != null) {
      hasPermission = true;
    }
    return hasPermission;
  }
}